<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );
if ( ! empty( $tabs ) ) : ?>
	<div class="flat-tabs bg-fff border-ra4 border-f-e6f3ff woo-tab">
		<ul class="tab-title style1 clearfix border-bt-e6f3ff"> 
			<?php if(isset($tabs['description']['callback'])) {?>
				<li class="item-title  overview">
		            <span class="inner"><?php esc_html_e('OVERVIEW','bookflare') ?></span>
		        </li>
			<?php }?>
	        <?php if(isset($tabs['additional_information']['callback'])) {?>
	         <li class="item-title infor">
	            <span class="inner"><?php esc_html_e('INFORMATION','bookflare') ?></span>
	        </li>
	        <?php }?>
	         <?php if(isset($tabs['reviews']['callback'])) {?>
	        <li class="item-title review">
	            <span class="inner"><?php esc_html_e('REVIEW','bookflare') ?></span>
	        </li>
	        <?php }?>
	    </ul>
		<div class="tab-content-wrap">
		<?php foreach ( $tabs as $key => $tab ) : ?>
			<?php if ( isset( $tab['callback'] ) ) { ?>
			<div class="tab-content">
                <div class="item-content">
					<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--<?php echo esc_attr( $key ); ?> panel entry-content wc-tab" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel">
						<?php  call_user_func( $tab['callback'], $key, $tab );  ?>
					</div>
				</div>
			</div>
			<?php } ?>
		<?php endforeach; ?>
		</div>
	</div>

<?php endif; ?>
