<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post, $woocommerce, $product;
?>

	<?php
		
		if ( version_compare( WC_VERSION, '3.0.0', '<' ) ) {
			$attachment_ids = $product->get_gallery_attachment_ids();
		} else {
			$attachment_ids = $product->get_gallery_image_ids();
		}
		if ( $attachment_ids ) {?>
			<div class="flat-carousel" data-gap="0" data-auto="true" data-column="1" data-column2="1" data-column3="1" data-loop="false" data-nav="true" data-dots="false">
				<div class="img-single-slider owl-carousel"  >
			<?php
			foreach ( $attachment_ids as $attachment_id ) {
				$thumbnail        = wp_get_attachment_image_src( $attachment_id, 'themesflat-shop-quick-view' );
				$thumbnail_post   = get_post( $attachment_id );
				$image_title      = $thumbnail_post->post_content;
				$html = '<div class="img-slider">';
					$html .= wp_get_attachment_image( $attachment_id, 'themesflat-shop-sinle-view', false);
				$html .= '</div>';
				echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
			}?>
			</div>
		</div>
		<?php }else{
			if ( has_post_thumbnail() ) {
				$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
				$thumbnail_post    = get_post( $post_thumbnail_id );
				$image_title       = $thumbnail_post->post_content;
				$html  = '<div class="img-slider">';
					$html .= get_the_post_thumbnail( $post->ID, 'themesflat-shop-sinle-view',array('class'=>'img-responsive','alt' => esc_attr ( get_the_title() )));
				$html .= '</div>';
			} else {
				$html  = '<div class="img-slider">';
					$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_attr__( 'Awaiting product image', 'bookflare' ) );
				$html .= '</div>';
			}
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );
		}
	?>
	