<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
get_header(); ?>
<?php if (is_active_sidebar('themesflat-woocommerce-sidebar')) {
	$content_class = 'col-lg-8 col-md-12';
	$sidebar_class = 'col-lg-4 col-md-12';
}else {
	$content_class = 'col-lg-12 col-md-12';
	$sidebar_class = '';
} ?>
<div class="single-product shop-single-page">
	<div class="container">
    	<div class="row">
			<div class="<?php echo esc_attr( $content_class ); ?>">
				<div id="primary-sidebar" class="primary-sidebar widget-area" role="complementary">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php wc_get_template_part( 'content', 'single-product' ); ?>
					<?php endwhile; wp_reset_postdata(); // end of the loop. ?>
				</div>
			</div>
			<?php if(is_active_sidebar('themesflat-woocommerce-sidebar')){?>
				<div class="<?php echo esc_attr( $sidebar_class ); ?>">
					<?php dynamic_sidebar('themesflat-woocommerce-sidebar');?>
				</div>
			<?php } ?>
        	
		</div>
	</div>
</div>
<?php do_action( 'woocommerce_output_related_products' ); ?>
<?php get_footer( 'shop' ); ?>