<?php
/**
 * Loop Rating
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.5
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' )
	return;
$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

if ( $rating_count > 0 ) : 
		?>
		<div class="review-stars-rated">
		    <div class="review-stars empty"></div>
		    <div class="review-stars filled" style="width:<?php echo esc_attr( ( $average / 5 ) * 100 ); ?>%;"></div>
		</div>
		<?php if ( comments_open() ) : ?>
			<?php //phpcs:disable ?>
				<div class="count-review-number">
					(<?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'bookflare' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)
				</div>
			<?php // phpcs:enable ?>
		<?php endif ?>
<?php endif; ?>
<?php 
if ( $rating_count == 0 ) : ?>
	<div class="review-stars-rated">
	    <div class="review-stars empty"></div>
	    <div class="review-stars filled" style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%;"></div>
	</div>
	<?php if ( comments_open() ) : ?>
			<?php //phpcs:disable ?>
			<div class="count-review-number">
				(<?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'bookflare' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)
			</div>
			<?php // phpcs:enable ?>
		<?php endif ?>
<?php endif; ?>