<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if (!defined('ABSPATH')) exit; // Exit if accessed directly
global $woocommerce_loop;
get_header('shop');
$column_content = 'col-xs-12 col-sm-12 col-md-12 col-lg-12';
$one_column = $woocommerce_loop['columns'] = 1;
?>
<div class="<?php echo esc_attr($column_content); ?>">
	<div class="archive-products">
		<?php do_action('woocommerce_archive_description');
		if (have_posts()) : ?>
			<div class="flat-start-shop-loop">
				<!-- Catalog Ordering-->
				<div class="themesflat-catalog-ordering">
					<?php woocommerce_catalog_ordering(); ?>
				</div>
			</div>
			<?php woocommerce_product_loop_start();
			 while (have_posts()) : the_post();
				wc_get_template_part('content', 'product');
			 endwhile;
			woocommerce_product_loop_end();?>
			<div class="themesflat-after-shop-loop">
				<!-- Pagination -->
				<div class="themesflat-shop-pagination">
					<?php
					/**
					 * woocommerce_after_shop_loop hook
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action('woocommerce_after_shop_loop');
					?>
				</div>
			</div>
		<?php elseif (!woocommerce_product_subcategories(array('before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)))) : ?>
			<?php wc_get_template('loop/no-products-found.php'); ?>
		<?php endif; ?>
	</div>
</div>
<?php get_footer('shop'); ?>