<?php
/**
 * Initialize woocommerce.
 *
 * @since   1.0.0
 * @package bookflare
 */
 if ( ! class_exists( 'WooCommerce' ) ) return;
 // Add this theme support woocommerce
add_theme_support( 'woocommerce' );
/**
 * Locate a template and return the path for inclusion.
 *
 * @since 1.0.0
 */
 function themesflat_wc_locate_template( $template, $template_name, $template_path ) {
	global $woocommerce;
	$_template = $template;
	if ( ! $template_path ) $template_path = $woocommerce->template_url;
	$theme_path = THEMESFLAT_DIR . '/woocommerce/templates/';
	// Look within passed path within the theme - this is priority
	$template = locate_template(
		array(
			trailingslashit( $template_path ) . $template_name,
			$template_name
		)
	);
	// Modification: Get the template from this folder, if it exists
	if ( ! $template && file_exists( $theme_path . $template_name ) )
	$template = $theme_path . $template_name;
	// Use default template
	if ( ! $template )
	$template = $_template;
	// Return what we found
	return $template;
}
add_filter( 'woocommerce_locate_template', 'themesflat_wc_locate_template', 10, 3 );
/*get path*/
function themesflat_wc_template_parts( $template, $slug, $name ) {
	$theme_path  = THEMESFLAT_DIR . '/woocommerce/templates/';
	if ( $name ) {
		$newpath = $theme_path . "{$slug}-{$name}.php";
	} else {
		$newpath = $theme_path . "{$slug}.php";
	}
	return file_exists( $newpath ) ? $newpath : $template;
}
add_filter( 'wc_get_template_part', 'themesflat_wc_template_parts', 10, 3 );
/*My Account*/
if ( ! function_exists( 'themesflat_wc_my_account' ) ) {
	function themesflat_wc_my_account() {
		$output = '';
		$output .= '<div class="my-account">';
			$output .= '<a class="check-account" href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">'.esc_html__('My Account','bookflare').'</a>';
			$output .= '<ul class="list-account">';
				if ( is_user_logged_in() ) {
					$output .= '<li><a class="check-account" href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">' . esc_html__( 'Profile', 'bookflare' ) . '</a></li>';
					$output .= '<li><a class="check-account" href="' . esc_url( wp_logout_url() ) . '">' . esc_html__( 'Sign Out', 'bookflare' ) . '</a></li>';
				} else {
					$output .= '<li><a class="check-account" href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">' . esc_html__( 'Sign In', 'bookflare' ) . '</a></li>';
				}
			$output .= '</ul>';
		$output .= '</div>';
		return apply_filters( 'themesflat_wc_my_account', $output );
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'wc_refresh_mini_cart_count');
function wc_refresh_mini_cart_count($fragments){
	global $woocommerce;
    ob_start();
    ?>
    <span class="count-cart">
        <?php echo WC()->cart->get_cart_contents_count(); ?>
    </span>
    <?php
        $fragments['.count-cart'] = ob_get_clean();
    return $fragments;
} 
/*My language*/
function themesflat_wc_my_language(){?>
	<div class="languages">
		<a href="#" class="lang_sel_sel"><?php esc_html_e('English','bookflare');?></a>
		<ul class="lists-language">
			<li class="icl-en">
				<a href="?lang=en" class="lang_sel_sel">
					<?php  esc_html_e('English','bookflare');?>
				</a>
			</li>
			<li class="icl-fr">
				<a href="?lang=fr" class="lang_sel_other">
					<?php esc_html_e('French','bookflare');?>
				</a>
			</li>
			<li class="icl-fr">
				<a href="?lang=it" class="lang_sel_other">
					<?php esc_html_e('Italia','bookflare');?>
				</a>
			</li>
		</ul>
	</div>
<?php }
/*Custom show number products archive*/
function themesflat_woocommerce_sortby_page( $options ){
	if( themesflat_choose_opt('number_post_page_prduct') && $no_page = (int)themesflat_choose_opt('number_post_page_prduct')){
		if( !isset( $options[ $no_page ])){
			$options[ $no_page ] = $no_page;
		}
	}
	return $options;
}
function themesflat_woocommerce_no_page( $page ){
	if(themesflat_choose_opt('number_post_page_prduct') && $no_page = (int)themesflat_choose_opt('number_post_page_prduct')){
		$page = $no_page;
	}
	return $page;
}
function themesflat_sort_by_page($count) {
 $count = 9;
 if (isset($_GET['themesflat_sortby'])) {
  $count = $_GET['themesflat_sortby'];
 }elseif(themesflat_choose_opt('number_post_page_prduct')){
 	$count = intval(themesflat_choose_opt('number_post_page_prduct'));
 }
 // else normal page load and no cookie
 return $count;
}
add_filter('loop_shop_per_page','themesflat_sort_by_page', 15);
/*Count all products*/
function themesflat_product_count_shortcode(){
	$count_posts = wp_count_posts( 'product' );
	return $count_posts->publish;
}

/**
 * Customize product quick view.
 *
 * @since  1.0
 */
function themesflat_boobflare_wc_quickview() {
	// Get product from request.
	if ( isset( $_POST['product'] ) && (int) $_POST['product'] ) {
		global $post, $product, $woocommerce;
		$id      = ( int ) $_POST['product'];
		$post    = get_post( $id );
		$product = wc_get_product( $id );
		if ( $product ) {
			// Get quickview template.
			include THEMESFLAT_DIR . '/woocommerce/templates/content-quickview-product.php';
		}
	}
	exit;
}
add_action( 'wp_ajax_themesflat_quickview', 'themesflat_boobflare_wc_quickview' );
add_action( 'wp_ajax_nopriv_themesflat_quickview', 'themesflat_boobflare_wc_quickview' );

/*SHOW TAG*/
function themesflat_get_tab() {
	global $post, $product;
	$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );
	echo wp_kses_post(wc_get_product_tag_list($product->get_id(),' ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'bookflare' ) . ' ', '</span>' ));
}
/**
 * Change number of related products output
 */ 
function woo_related_products_limit() {
  global $product;
	$text_relate_description = themesflat_choose_opt('number_post_relate_prduct')?themesflat_choose_opt('number_post_relate_prduct'):3;
	$args['posts_per_page'] = $text_relate_description;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'woo_related_products_limit' );
/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );

function new_loop_shop_per_page( $cols ) {
  // $cols contains the current number of products per page based on the value stored on Options -> Reading
  // Return the number of products you wanna show per page.
	$number_post_page_prduct = themesflat_choose_opt('number_post_page_prduct')?themesflat_choose_opt('number_post_page_prduct'):9;
  $cols = $number_post_page_prduct;
  return $cols;
}

function wc_empty_cart_message_cs() {
  echo '<p class="cart-empty">' . wp_kses_post( apply_filters( 'wc_empty_cart_message', esc_html__( 'Your cart is currently empty .', 'bookflare' ) ) ) . '</p>';
}
remove_action( 'woocommerce_cart_is_empty', 'wc_empty_cart_message', 10 );
add_action( 'woocommerce_cart_is_empty', 'wc_empty_cart_message_cs', 10 );

/**
 * Reorder product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_reorder_tabs', 98 );
function woo_reorder_tabs( $tabs ) {

	$tabs['description']['priority'] = 5;		// Description first 
	$tabs['reviews']['priority'] = 20;			// Reviews third
	$tabs['additional_information']['priority'] = 15;	// Additional information second 

	return $tabs;
}
/**
 * Breadcrumbs
 *
 * @see woocommerce_breadcrumb()
 */
add_action( 'woocommerce_breadcrumb', 'woocommerce_breadcrumb', 20, 0 );
/**
 * Product Loop Items
 *
 * @see woocommerce_template_loop_add_to_cart()
 * @see woocommerce_template_loop_product_thumbnail()
 * @see woocommerce_template_loop_price()
 * @see woocommerce_template_loop_rating()
 */
add_action( 'woocommerce_template_loop_add_to_cart', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'woocommerce_template_loop_product_thumbnail', 'woocommerce_template_loop_product_thumbnail', 10 );
add_action( 'woocommerce_template_loop_price', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_template_loop_rating', 'woocommerce_template_loop_rating', 5 );

/**
 * Sale flashes
 *
 * @see woocommerce_show_product_loop_sale_flash()
 * @see woocommerce_show_product_sale_flash()
 */
add_action( 'woocommerce_show_product_loop_sale_flash', 'woocommerce_show_product_loop_sale_flash', 10 );
add_action( 'woocommerce_show_product_sale_flash', 'woocommerce_show_product_sale_flash', 10 );
/**
 * Breadcrumbs
 *
 * @see onsky_theme_woocommerce_breadcrumb()
 */
add_filter( 'woocommerce_breadcrumb_defaults', 'onsky_theme_woocommerce_breadcrumb_defaults', 20, 1 );
/**
 * Products Loop
 *
 * @see woocommerce_result_count()
 * @see woocommerce_catalog_ordering()
 * @see woocommerce_reset_loop()
 */
add_action( 'woocommerce_result_count', 'woocommerce_result_count', 20 );
add_action( 'woocommerce_catalog_ordering', 'woocommerce_catalog_ordering', 30 );
/**
 * Before Single Products Summary Div
 *
 * @see woocommerce_show_product_images()
 * @see woocommerce_show_product_thumbnails()
 */
add_action( 'woocommerce_show_product_images', 'woocommerce_show_product_images', 20 );
add_action( 'woocommerce_show_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );
/**
 * Product Summary Box
 *
 * @see woocommerce_template_single_title()
 * @see woocommerce_template_single_price()
 * @see woocommerce_template_single_excerpt()
 * @see woocommerce_template_single_meta()
 * @see woocommerce_template_single_sharing()
 */
add_action( 'woocommerce_template_single_title', 'woocommerce_template_single_title', 5 );
add_action( 'woocommerce_template_single_rating', 'woocommerce_template_single_rating', 10 );
add_action( 'woocommerce_template_single_price', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_template_single_excerpt', 'woocommerce_template_single_excerpt', 20 );
add_action( 'woocommerce_template_single_meta', 'woocommerce_template_single_meta', 40 );
add_action( 'woocommerce_template_single_sharing', 'woocommerce_template_single_sharing', 50 );

/**
 * Product Add to cart
 *
 * @see woocommerce_template_single_add_to_cart()
 * @see woocommerce_simple_add_to_cart()
 * @see woocommerce_grouped_add_to_cart()
 * @see woocommerce_variable_add_to_cart()
 * @see woocommerce_external_add_to_cart()
 */
add_action( 'woocommerce_template_single_add_to_cart', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'woocommerce_simple_add_to_cart', 'woocommerce_simple_add_to_cart', 30 );
add_action( 'woocommerce_grouped_add_to_cart', 'woocommerce_grouped_add_to_cart', 30 );
add_action( 'woocommerce_variable_add_to_cart', 'woocommerce_variable_add_to_cart', 30 );
add_action( 'woocommerce_external_add_to_cart', 'woocommerce_external_add_to_cart', 30 );
/**
 * After Single Products Summary Div
 *
 * @see woocommerce_output_product_data_tabs()
 * @see woocommerce_upsell_display()
 * @see woocommerce_output_related_products()
 */
add_action( 'woocommerce_output_product_data_tabs', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_upsell_display', 'woocommerce_upsell_display', 15 );
add_action( 'woocommerce_output_related_products', 'woocommerce_output_related_products', 20 );
/**
 * Checkout
 *
 * @see woocommerce_checkout_login_form()
 * @see woocommerce_checkout_coupon_form()
 * @see woocommerce_order_review()
 */
add_action( 'woocommerce_checkout_login_form', 'woocommerce_checkout_login_form', 10 );
add_action( 'woocommerce_checkout_coupon_form', 'woocommerce_checkout_coupon_form', 10 );
add_action( 'woocommerce_order_review', 'woocommerce_order_review', 10 );
add_action( 'woocommerce_checkout_payment', 'woocommerce_checkout_payment', 20 );
