<?php
if ( ! get_theme_mod( 'show_related_post' ) )
    return;

$args = array(
    'layout'        => get_theme_mod( 'related_post_style', 'blog-grid' ),
    'post_type'           => 'post',
    'post_status' => 'publish',
    'posts_per_page'      =>get_theme_mod( 'number_related_post', 2),
    'post__not_in'        => array(get_the_ID()),
);
$layout =  get_theme_mod( 'grid_columns_post_related',2);
switch ($layout) {
    case 2:
        $content_class = 'col-lg-6 col-md-6 col-sm-12';
        break;
    case 3:
        $content_class = 'col-lg-4 col-md-6 col-sm-12';
        break;
    case 4:
        $content_class = 'col-lg-3 col-md-6 col-sm-12';
        break;
    default:
        $content_class = 'col-lg-6 col-md-6 col-sm-12';
        break;
}

$categories = (array) get_the_category();
if ( empty( $tags ) && empty( $categories ) ){
    return;
}
$cat = ',';
foreach ($categories as $value) {
   $cat .=  ','.$value->term_id;
}
$cat = str_replace (',,','', $cat);
$args['cat'] = explode(",",$cat);

?>
<section class="related-post related-posts-box">
    <div class="box-wrapper">
        <h3 class="box-title"><?php esc_html_e( 'Related Posts', 'bookflare' ) ?></h3>
        <div class="box-content content-wrap">
             <div class="row">
               <?php 
                    // The Query
                    $query = new WP_Query( $args );
                    // The Loop
                    if ( $query->have_posts() ) {
                        while ( $query->have_posts() ) {
                            $query->the_post();
                            $title = get_the_title( );
                            ?>
                            <div class="<?php echo esc_attr( $content_class ); ?>">
                               <div class="event style2 border-f-e6f3ff">
                                    <div class="event-img">
                                        <a href="<?php the_permalink(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'themesflat-blog-grid' ,array( 'alt' => $title )); ?></a>
                                    </div>
                                    <div class="event-content">
                                        <h6 class="title"><a href="<?php the_permalink(); ?>"><?php echo esc_attr($title); ?></a></h6>
                                        <div class="meta-list">
                                            <ul class="list">
                                                <li class="address"><?php if (get_the_category('') != '') {the_category(', ');}?></li>
                                            </ul>
                                        </div>
                                        <div class="meta-date flat-text-center">
                                            <span class="day"><?php echo get_the_date('d');?></span>
                                            <span class="month"><?php echo get_the_date('F');?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                       <?php }
                    } else {
                        // no posts found
                    }
                    // Restore original Post Data
                    wp_reset_postdata(); 
                ?>
            </div>
        </div>
    </div>
</section>