<?php
global $wp_query;
  $big = 999999999;
  $total_pages = $wp_query->max_num_pages; 
  $query_args   = array();
  $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
  $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';
  $pages = paginate_links( array(
    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
    'format' => $format,
    'current' => max( 1, get_query_var('paged') ),
    'total' => $total_pages,
    'prev_next' => false,
    'type'  => 'array',
    'prev_next'   => true,
    'prev_text'    => esc_html__( 'Previous', 'bookflare' ),
    'next_text'    => esc_html__( 'Next', 'bookflare'),
    'mid_size' => 3,
	'add_args' => array_map( 'urlencode', $query_args ),
  ) );
  
$numeric_links = paginate_links( array(
	'base'     => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	'format'   => $format,
	'total'    => $GLOBALS['wp_query']->max_num_pages,
	'current'  => $paged,
	'mid_size' => 3,
	'add_args' => array_map( 'urlencode', $query_args ),
	'prev_next' => false
) );

$next_link = get_next_posts_link( esc_html__( 'Next', 'bookflare' ) );
$prev_link = get_previous_posts_link( esc_html__( 'Previous Post', 'bookflare' ) );
global $themesflat_paging_style;
global $themesflat_paging_for;
?>

<?php if ( $themesflat_paging_style == 'pager' && ! ( empty( $next_link ) && empty( $prev_link ) ) ): ?>

	<div class="navigation paging-navigation pager" >
		<div class="pagination loop-pagination">
			<?php echo wp_kses_post( $prev_link ) ?>
			<?php echo wp_kses_post( $next_link ) ?>
		</div>
	</div>

<?php elseif ( $themesflat_paging_style == 'numeric' && ! empty( $numeric_links ) ): ?>

	<div class="navigation paging-navigation numeric" >
		<div class="pagination loop-pagination">
			<?php echo wp_kses_post( $numeric_links ) ?>
		</div>
	</div>
<?php elseif ( ! empty( $pages ) ): ?>
	<div class="navigation  paging-navigation pager-numeric" >
		<div class="pagination loop-pagination">
			<?php 
				if ( is_array( $pages ) ) {
			  //Get current page
			    $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var( 'paged' );
			  //Disable Previous button if the current page is the first one
			    if ($paged == 1) {
			      echo '<ul class="list pagination-wrap"><li class="disabled"><a class="btn-navs">Prev</a></li>';
			    } else {
			      echo '<ul class="list pagination-wrap"><li><a class="btn-navs" href="' . get_previous_posts_page_link() . '">'.esc_html__('Prev','bookflare').'</a></li>';
			    }
			    for ($i=1; $i<=$total_pages; $i++) {
			      if ($i == $paged) {
			        echo '<li class="active"><a class="pagination-link" href="' . get_pagenum_link($i) . '">' . $i . '</a></li>';
			      } else {
			        echo '<li><a class="pagination-link" href="'. get_pagenum_link($i) . '">' . $i . '</a></li>';
			      }
			    }
			    //Disable Next button if the current page is the last one
			    if ($paged<$total_pages) {
			      echo '<li><a class="btn-navs" href="' . get_next_posts_page_link() . '">'.esc_html__('Next','bookflare').'</a></li>
			      ';
			    } else {
			      echo '<li class="disabled"><a class="btn-navs">'.esc_html__('Next','bookflare').'</a></li>';
			    }
			    echo '</ul>';
			  } ?>
		</div>
	</div>

<?php endif ;
