<?php 
    if ( is_page() && is_page_template( 'tpl/front-page.php' ) ) {
        echo '<div class="clearfix"></div>';
        return;
    }

    $title = esc_html__( 'Archives', 'bookflare' );

    if ( is_home() ) {
        if (is_front_page() ) {
            $title = esc_html__( 'Home page', 'bookflare' );
        }
        else {
            $title = esc_html( wp_title('',FALSE) );
        }
    } elseif ( is_singular() ) {
        if (is_single()) {
            $title = get_the_title();
        }elseif(is_page_template('tpl/page_single.php')) {
            $title = get_the_title();
        }
         elseif(is_page_template('tpl/page_no_title.php')) {
            $title = '';
        }else {
            $title = get_the_title();
        }
    } elseif ( is_search() ) {
        $title = sprintf( esc_html__( 'Search results for &quot;%s&quot;', 'bookflare' ), get_search_query() );
    } elseif ( is_404() ) {
        $title = esc_html__( 'Not Found', 'bookflare' );
    } elseif ( is_author() ) {
        the_post();
        $title = sprintf( esc_html__( 'Author Archives: %s', 'bookflare' ), get_the_author() );
        rewind_posts();
    } elseif ( is_day() ) {
        $title = sprintf( esc_html__( 'Daily Archives: %s', 'bookflare' ), get_the_date() );
    } elseif ( is_month() ) {
        $title = sprintf( esc_html__( 'Monthly Archives: %s', 'bookflare' ), get_the_date( 'F Y' ) );
    } elseif ( is_year() ) {
        $title = sprintf( esc_html__( 'Yearly Archives: %s', 'bookflare' ), get_the_date( 'Y' ) );
    } elseif ( is_tax() || is_category() || is_tag() ) {
        $title = single_term_title( '', false );
    }
?>

<?php 
    $page_title_style_breadcrumb = themesflat_choose_opt('page_title_style_breadcrumb');
    $position_page_title = themesflat_choose_opt('position_page_title');
    $show_parallax_page_title = themesflat_choose_opt('show_parallax_page_title')?themesflat_choose_opt('show_parallax_page_title'):0;

    if (themesflat_choose_opt('show_page_title') != 1 || $title =='' ) return;

?>
<!-- Page title -->
<section class="flat-title-page parallax parallax-img <?php if($show_parallax_page_title): ?>parallax-on <?php endif; ?> <?php if ($page_title_style_breadcrumb == 'style_page_title_1' ): echo esc_attr('style_page_title_1'); endif; ?>">
    <div class="overlay"></div>  
    
    <div class="container wrap-title-page <?php if($position_page_title == 2 ){echo esc_attr('flat-text-right');}elseif ($position_page_title == 3 ) { echo esc_attr('flat-text-center') ;}else { echo esc_attr('flat-text-left') ;} ?>"> 
        <div class="title-page">
            <?php 
            if ( themesflat_choose_opt('show_page_title_heading') == 1 ) {
                    printf('<h2 class="title font-weight-700">%s</h2>',$title);
             }
             if ( themesflat_choose_opt('page_title_textarea') != '' && !is_single() ) {
                $subtitle = themesflat_choose_opt('page_title_textarea');
                printf('<p class="text">%s</p>',$subtitle);
             }                 
            ?>
        </div><!-- /.title-page -->  
        <?php if ( themesflat_choose_opt( 'breadcrumb_enabled' ) == 1 ):
             if ($page_title_style_breadcrumb == 'style_page_title_1' ): ?>
                <div class="breadcrumbs style2">
                         <?php 
                            themesflat_breadcrumb_trail( array(
                                'separator'   => themesflat_choose_opt('breadcrumb_separator'),
                                'show_browse' => true,
                                'labels'      => array(
                                'browse'  => themesflat_choose_opt( 'bread_crumb_prefix', esc_html__( '', 'bookflare' ) ),
                                    'home'    => esc_html__( 'Home', 'bookflare' )
                                )
                            ) );
                        ?> 
                </div><!-- /.breadcrumbs --> 
            <?php else : ?>
                    <div class="box-title-page ">
                        <div class="box">
                            <?php 
                                themesflat_breadcrumb_trail( array(
                                    'separator'   => themesflat_choose_opt('breadcrumb_separator'),
                                    'show_browse' => true,
                                    'labels'      => array(
                                    'browse'  => themesflat_choose_opt( 'bread_crumb_prefix', esc_html__( '', 'bookflare' ) ),
                                        'home'    => esc_html__( 'Home', 'bookflare' )
                                    )
                                ) );
                            ?>             
                        </div>
                    </div>
            <?php  
                endif;
            endif; 
            ?>      
    </div><!-- /.container -->                      
</section><!-- /.page-title --> 