<?php
/**
 * Template for displaying the curriculum of a course
 *
 * @author  Themesflat
 * @version 3.0.0
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$course = LP()->global['course'];
$curriculum_heading = apply_filters( 'learn_press_curriculum_heading', esc_html__( 'Course Curriculum', 'bookflare' ));
?>
<div class="course-curriculum" id="learn-press-course-curriculum">
	<?php if ( $curriculum_heading ) { ?>
		<h3 class="course-curriculum-title"><?php echo esc_attr($curriculum_heading); ?></h3>
	<?php } ?>
	<?php do_action( 'learn_press_before_single_course_curriculum' );?>
	<?php if ( $curriculum = $course->get_curriculum() ): ?>
		<ul class="curriculum-sections">
			<?php foreach ( $curriculum as $section ) : ?>
				<?php learn_press_get_template( 'single-course/loop-section.php', array( 'section' => $section ) ); ?>
			<?php endforeach; ?>
		</ul>
	<?php else: ?>
		<span class="no_curriculumn"><?php echo apply_filters( 'learn_press_course_curriculum_empty', esc_html__( 'Curriculum is empty', 'bookflare' ) ); ?></span>
	<?php endif; ?>
	<?php do_action( 'learn_press_after_single_course_curriculum' ); ?>
</div>