<?php
/**
 * Template for displaying content of learning course
 * @version 3.0.0
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$course = LP()->global['course'];
$user   = learn_press_get_current_user();
$profile       = learn_press_get_profile();
$query         = $profile->query_courses( 'purchased');
$_id = get_the_ID();
$review_is_enable = themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' );
$courses_length = (int)themesflat_choose_opt('courses_archive_post_excepts_length')?(int)themesflat_choose_opt('courses_archive_post_excepts_length'):40;
$courses_more = themesflat_choose_opt('excerpt_more_courses')?themesflat_choose_opt('excerpt_more_courses'):'';
$id_enroll[] = '';
$statust_enroll = 0;
foreach ( $query['items'] as $user_course ) { 
    array_push($id_enroll, $user_course->get_id());   
}
for($i = 0; $i < sizeof($id_enroll);$i++){
    if($id_enroll[$i] == $_id){
        $statust_enroll = 1;
    }
}
if (function_exists( 'themesflat_custom_shortcodes_class' )) {
    setPostViews($_id);
}
?>
<?php
/**
 * @deprecated
 */
do_action( 'learn_press_before_content_landing' );
$page_id = learn_press_get_page_id( 'checkout' );
    $page    = false;
    if ( $page_id ) {
        $page = get_post( $page_id );
    }
    if ( ! $page ) {
        // Only show for admin
        if ( current_user_can( 'manage_options' ) ) {?>
            <div class="learn-press-message success">
                <?php esc_html_e( 'Checkout page hasn\'t been setup or page does not exists.', 'bookflare' ) ; ?>
            </div>
        <?php } else {
            ?>
            <div class="learn-press-message success">
                <?php esc_html_e('Checkout error! Please contact with admin for getting more information.', 'bookflare' ) ; ?>
            </div>
        <?php
            
        }
    }
?>
<div class="content-page-wrap courses-single-page">
    <div class="course-single">
        <div class="img-single">
        	<div class="course-image">
				<?php if(has_post_thumbnail()){
					the_post_thumbnail('themesflat-blog',array('class'=>'img-responsive','alt' => esc_attr ( get_the_title() )));
				} ?>
                <?php themesflat_custom_course_sale(); ?>
			</div>
        </div>
        <div class="content">
            <div class="heading"><?php do_action( 'learn_press_courses_loop_single_item_title' ); ?>
                <p class="description">
                	<?php echo themesflat_custom_excerpt($_id,intval($courses_length),$courses_more);?>
                </p>
            </div>
            <div class="price_courses">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-6">
                        <div class="price-wrap">
                            <?php  echo themesflat_custom_course_price();?>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-6">
                        <div class="wrap-cart flat-text-right">
                            <?php
                            if($statust_enroll != 1){
                                echo themesflat_custom_course_button();
                            }else {
                                esc_html_e('You have enrolled', 'bookflare' );
                            }
                            ?>
                        </div>  
                    </div>
                </div>
            </div>
           <?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
           if(!empty($tflat_teacher)){
				themesflat_teacher_by_id($tflat_teacher['teacher'],$_id);
            } ?>
        </div>
    </div> <!-- /.course-single -->
    <div class="flat-tabs bg-fff border-ra4 border-f-e6f3ff">
        <ul class="tab-title style1 clearfix border-bt-e6f3ff"> 
            <li class="item-title  overview">
                <span class="inner"><?php esc_html_e('OVERVIEW','bookflare');?></span>
            </li>
            <li class="item-title event">
                <span class="inner"><?php esc_html_e('CURRICULUM','bookflare');?></span>
            </li>
            <?php if (get_field('text_requirements') != ''): ?>
            <li class="item-title requirements">
                <span class="inner"><?php esc_html_e('REQUIREMENTS','bookflare');?></span>
            </li>
            <?php endif ?>
            <?php if ($review_is_enable): ?>
				<li class='item-title review'>
					<span class="inner"><?php esc_html_e('FEATURED REVIEW','bookflare');?><?php echo ' (' . learn_press_get_course_rate_total( $_id ) . ')'; ?></span>
				</li>
			<?php endif ?>
        </ul>
        <div class="tab-content-wrap">
            <div class="tab-content">
                <div class="item-content">
                    <?php do_action( 'learn_press_begin_course_content_course_description' );
			             the_content(); 
                    ?>
                    <?php 
                    $custom_terms = get_the_terms($_id,'course_tag');
                    if(!empty($custom_terms) && is_array($custom_terms) ){?>
                        <div class="wrap-checkmark-tag clearfix">
                            <div class="tags one-of-two">
                                <?php themesflat_tag_single_course($_id); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="tab-content">
                <div class="item-content">
                    <?php
						learn_press_course_curriculum_tab();
					?>
                </div>
            </div>
            <?php if (get_field('text_requirements') != ''): ?>
                <div class="tab-content">
                    <div class="item-content">
                        <?php the_field('text_requirements'); ?>
                    </div>
                </div>
            <?php endif ?>
            <div class="tab-content">
                <div class="item-content">
	            <?php if($review_is_enable): ?>
					<?php themesflat_course_review($_id,$statust_enroll); ?>
				<?php endif; ?>
				 </div>
            </div>
        </div>
    </div> <!-- /.flat-tabs -->
</div> <!-- /.content-page-wrap -->
<?php
/**
 * @deprecated
 */
do_action( 'learn_press_after_content_landing' );
?>