<?php 
add_filter('learn_press_get_courses','lp_course', $args['posts_per_page'] = 2);
if ( !function_exists( 'themesflat_custom_course_price' ) ) {
	function themesflat_custom_course_price() {
		if ( !defined( 'ABSPATH' ) ) {
			exit;
		}
		$course = LP()->global['course'];
		if(strcasecmp($course->get_price_html(),'Free')== 0){?>
			<span class="course-price green"><?php echo esc_attr($course->get_price_html());?></span>
		<?php }else{?>
			<span class="course-price"><?php echo esc_attr($course->get_price_html());?></span>
			<?php
			if($course->get_origin_price()!= $course->get_price()){
				$origin_price_html = $course->get_origin_price_html();?>
				<span class="course-origin-price"><?php echo esc_attr($origin_price_html); ?></span>
			<?php }
		}
	}
}
remove_action( 'learn-press/before-main-content', 'learn_press_breadcrumb', 10 );
if ( !function_exists( 'themesflat_custom_course_sale' ) ) {
	function themesflat_custom_course_sale() {
		if ( !defined( 'ABSPATH' ) ) {
			exit;
		}
		$course = LP()->global['course'];
		if($course->get_origin_price()!= $course->get_price()){
                $origin_price_html = $course->get_origin_price_html();?>
                <span class="onsale-learnpress">Sale!</span>
        <?php }
	}
}
if ( !function_exists( 'themesflat_custom_course_price_id' ) ) {
	function themesflat_custom_course_price_id($course_id ) {
		if ( !defined( 'ABSPATH' ) ) {
			exit;
		}
		$course = LP()->global['course'];
		$course_item = LP_Course::get_course( $course_id );
		if(strcasecmp($course_item->get_price_html(),'Free')== 0){?>
			<span class="course-price green"><?php echo esc_attr($course_item->get_price_html());?></span>
		<?php }else{?>
			<span class="course-price"><?php echo esc_attr($course_item->get_price_html());?></span>
			<?php
			if($course_item->get_origin_price()!= $course_item->get_price()){
				$origin_price_html = $course_item->get_origin_price_html();?>
				<span class="course-origin-price"><?php echo esc_attr($origin_price_html); ?></span>
			<?php }
		}
	}
}
if ( !function_exists( 'themesflat_custom_course_price_color' ) ) {
	function themesflat_custom_course_price_color() {
		if ( !defined( 'ABSPATH' ) ) {
			exit;
		}
		$course = LP()->global['course'];
		if(strcasecmp($course->get_price_html(),'Free') == 0){
			echo esc_attr('text-005eea ');
		}else if($course->get_price() <= '50' && $course->get_price() >= '1'){
			echo esc_attr('text-ea0042 ');
		}else {
			echo esc_attr('text-00dcea ');
		}
	}
}
if ( !function_exists( 'themesflat_custom_course_button' ) ) {
	function themesflat_custom_course_button() {
		if ( !defined( 'ABSPATH' ) ) {
			exit; // Exit if accessed directly
		}
		$course = LP()->global['course'];
		$course_id = get_the_ID();
		if ( !$course->is_required_enroll() ) {
			esc_html_e('You have enrolled', 'bookflare' );
			return;
		}
		$guest_checkout = ( LP()->checkout()->is_enable_guest_checkout() ) ? 'guest_checkout' : '';
		$checkout_redirect = add_query_arg( 'enroll-course', $course->get_id(), $course->get_permalink() );
		$login_redirect    = add_query_arg( 'redirect_to', $checkout_redirect, flat_get_login_page_url() );
		
		?>
		<div class="lp-course-buttons">

			<?php do_action( 'learn-press/before-purchase-form' ); ?>

			<form name="purchase-course" class="purchase-course form-purchase-course <?php echo esc_attr($guest_checkout); ?>" method="post" enctype="multipart/form-data">

				<?php do_action( 'learn-press/before-purchase-button' ); ?>

				<input type="hidden" name="purchase-course" value="<?php echo esc_attr( $course->get_id() ); ?>" />
				<input type="hidden" name="purchase-course-nonce"
				       value="<?php echo esc_attr( LP_Nonce_Helper::create_course( 'purchase' ) ); ?>" />

				<button class="flat-button btn-buy border-ra4 flat-enroll-course-button">
					<?php esc_html_e( 'Buy now', 'bookflare' ); ?>
				</button>
				<input type="hidden" name="redirect_to" value="<?php echo esc_url( $login_redirect ); ?>">

				<?php do_action( 'learn-press/after-purchase-button' ); ?>

			</form>

			<?php do_action( 'learn-press/after-purchase-form' ); ?>

		</div>
		<?php
	}
}
/**
 * Display rating stars
 *
 * @param $rate
 */
if ( ! function_exists( 'themesflat_print_rating' ) ) {
	function themesflat_print_rating( $rated ) {
		if ( ! themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' ) ) {
			return;
		}
		$percent = ( ! $rated ) ? 0 : min( 100, ( round( $rated * 2 ) / 2 ) * 20 );
		$title   = sprintf( esc_html__('%s out of 5 stars', 'bookflare' ), $rated );

		?>
		<div class="review-stars-rated" title="<?php echo esc_attr( $title ); ?>">
		    <div class="review-stars empty"></div>
		    <div class="review-stars filled" style="width:<?php echo esc_attr($percent); ?>%;"></div>
		</div>
		<?php
	}
}
if ( ! function_exists( 'themesflat_lesson_duration' ) ) {
	function themesflat_lesson_duration( $lesson_id ) {
		$duration = get_post_meta( $lesson_id, '_lp_duration', true );
		$hour     = floor( $duration / 60 );
		if ( $hour == 0 ) {
			$hour = '';
		} else {
			$hour = $hour . esc_html( 'h');
		}
		$minute = $duration % 60;
		$minute = $minute . esc_html( 'm');
		return $hour . $minute;
	}
}
if ( ! function_exists( 'themesflat_plugin_active' ) ) {
	function themesflat_plugin_active( $plugin ) {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( class_exists( $plugin ) ) {
			return true;
		}
		return false;
	}
}

/**
 * Display course review
 */
if ( ! function_exists( 'themesflat_course_review' ) ) {
	function themesflat_course_review($get_post_ID,$statust_enroll) {
		if ( ! themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' ) ) {
			return;
		}
		$course_id     = $get_post_ID;
		$course_review = learn_press_get_course_review( $course_id, isset( $_REQUEST['paged'] ) ? $_REQUEST['paged'] : 1, 5, true );
		$course_rate   = learn_press_get_course_rate( $course_id );
		$total         = learn_press_get_course_rate_total( $course_id );
		$reviews       = $course_review['reviews'];
		?>
		<div class="course-rating">
			<div class="average-rating">
				<div class="rating-box">
					<div class="average-value"><?php echo esc_attr(( $course_rate ) ? esc_html( round( $course_rate, 1 ) ) : 0); ?></div>
					<div class="review-star">
						<?php themesflat_print_rating( $course_rate ); ?>
					</div>
					<div class="review-amount">
						<?php $total ? printf( _n( '%1$s rating', '%1$s ratings', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( '0 rating', 'bookflare' ); ?>
					</div>
				</div>
			</div>
			<div class="detailed_rating">
				<div class="rating-box">
					<?php themesflat_detailed_rating( $course_id, $total ); ?>
				</div>
			</div>
		</div>
		<?php if ( $reviews ) { ?>
			<div class="course-review">
				<div id="course-reviews" class="content-review">
					<ul class="course-reviews-list">
						<?php foreach ( $reviews as $review ) : ?>
							<li>
								<div class="review-container">
									<div class="review-author">
										<?php echo get_avatar( $review->ID, 95 ); ?>
									</div>
									<div class="review-text">
										<h4 class="author-name"><?php echo esc_html( $review->display_name ); ?></h4>
										<div class="review-star">
											<?php themesflat_print_rating( $review->rate ); ?>
										</div>
										<p class="review-time"><i class="fa fa-clock-o"></i> <?php echo date('F j, Y', strtotime($review->user_registered)); ?> <?php esc_html_e('at','bookflare'); ?> <?php echo date('h:i a', strtotime($review->user_registered)); ?></p>
										<div class="description">
											<p><?php echo esc_html( $review->content ); ?></p>
										</div>
									</div>
								</div>
							</li>
						<?php endforeach; ?>
					</ul>
				</div>
			</div>
		<?php } ?>
		<?php if ( empty( $course_review['finish'] ) && $total ) : ?>
			<div class="review-load-more">
				<span id="course-review-load-more" data-paged="<?php echo esc_attr( $course_review['paged'] ); ?>"><i class="fa fa-angle-double-down"></i></span>
			</div>
		<?php endif; ?>
		<?php themesflat_review_button( $course_id,$statust_enroll); ?>
		<?php
	}
}
/**
 * Display table detailed rating
 *
 * @param $course_id
 * @param $total
 */
if ( ! function_exists( 'themesflat_detailed_rating' ) ) {
	function themesflat_detailed_rating( $course_id, $total ) {
		global $wpdb;
		$query = $wpdb->get_results( $wpdb->prepare(
			"
		SELECT cm2.meta_value AS rating, COUNT(*) AS quantity FROM $wpdb->posts AS p
		INNER JOIN $wpdb->comments AS c ON p.ID = c.comment_post_ID
		INNER JOIN $wpdb->users AS u ON u.ID = c.user_id
		INNER JOIN $wpdb->commentmeta AS cm1 ON cm1.comment_id = c.comment_ID AND cm1.meta_key=%s
		INNER JOIN $wpdb->commentmeta AS cm2 ON cm2.comment_id = c.comment_ID AND cm2.meta_key=%s
		WHERE p.ID=%d AND c.comment_type=%s AND c.comment_approved=%s
		GROUP BY cm2.meta_value",
			'_lpr_review_title',
			'_lpr_rating',
			$course_id,
			'review',
			'1'
		), OBJECT_K
		);
		?>
		<div class="detailed-rating">
			<?php for ( $i = 5; $i >= 1; $i -- ) : ?>
				<div class="stars">
					<div class="key"><?php ( $i === 1 ) ? printf( esc_html__( '%s star', 'bookflare' ), $i ) : printf( esc_html__( '%s stars', 'bookflare' ), $i ); ?></div>
					<div class="bar">
						<div class="full_bar">
							<div style="<?php echo esc_attr( ( $total && ! empty( $query[ $i ]->quantity ) ) ? esc_attr( 'width: ' . ( $query[ $i ]->quantity / $total * 100 ) . '%' ) : 'width: 0%'); ?>"></div>
						</div>
					</div>
					<div class="value"><?php echo empty( $query[ $i ]->quantity ) ? '0' : esc_html( $query[ $i ]->quantity ); ?></div>
				</div>
			<?php endfor; ?>
		</div>
		<?php
	}
}
if ( ! function_exists( 'themesflat_review_button' ) ) {
	function themesflat_review_button( $course_id ,$statust_enroll) {
		if ( ! themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' ) ) {
			return;
		}

		if ( ! get_current_user_id() ) {
			return;
		}

		if ($statust_enroll == 1) {?>
			<button class="write-a-review flat-button btn-read-more"><?php esc_html_e( 'Write a review', 'bookflare' ); ?></button>
				<div class="course-review-wrapper" id="course-review">
				    <div class="review-overlay"></div>
				    <div class="review-form" id="review-form">
				        <div class="form-overlay-review"></div>
				        <form>
				            <h3>
								<?php esc_html_e( 'Write a review', 'bookflare' ); ?>
				                <a href="" class="close dashicons dashicons-no-alt"></a>
				            </h3>
				            <h6>
								<?php esc_html_e( 'Only be write a review once and public after checking by admin', 'bookflare' ); ?>
				            </h6>
				            <ul class="review-fields">
								<?php do_action( 'learn_press_before_review_fields' ); ?>
				                <li>
				                    <label><?php esc_html_e( 'Title', 'bookflare' ); ?> <span class="required">*</span></label>
				                    <input type="text" required name="review_title"/>
				                </li>
				                <li>
				                    <label><?php esc_html_e( 'Content', 'bookflare' ); ?><span class="required">*</span></label>
				                    <textarea required name="review_content"></textarea>
				                </li>
				                <li>
				                    <label><?php esc_html_e( 'Rating', 'bookflare' ); ?><span class="required">*</span></label>
				                    <ul class="review-stars">
										<?php for ( $i = 1; $i <= 5; $i ++ ) { ?>
				                            <li class="review-title" title="<?php echo esc_attr($i); ?>">
				                                <span class="dashicons dashicons-star-empty"></span></li>
										<?php } ?>
				                    </ul>
				                </li>
								<?php do_action( 'learn_press_after_review_fields' ); ?>
				                <li class="review-actions">
				                    <button type="button" class="submit-review flat-button btn-read-more"
				                            data-id="<?php the_ID(); ?>"><?php esc_html_e( 'Add review', 'bookflare' ); ?></button>
				                    <span class="ajaxload"></span>
				                    <button type="button" class="close"><?php esc_html_e( 'Cancel', 'bookflare' ); ?></button>
				                    <span class="error"></span>
									<?php wp_nonce_field( 'learn_press_course_review_' . get_the_ID(), 'review-nonce' ); ?>
				                    <input type="hidden" name="rating" value="0">
				                    <input type="hidden" name="lp-ajax" value="add_review">
				                    <input type="hidden" name="comment_post_ID" value="<?php echo get_the_ID(); ?>">
				                </li>
				            </ul>
				        </form>
				    </div>
				</div>
<?php
		}
	}
}
function themesflat_count_student($get_post_ID){
	$course = LP()->global['course'];
	$count_student = learn_press_count_students_enrolled($get_post_ID);
	echo esc_html( $count_student );
 }
if ( !function_exists( 'learn_press_count_students_enrolled' )){
	function learn_press_count_students_enrolled($course_id) {
		$student = get_post_meta( $course_id, 'count_enrolled_users', true );
		$student_fake = get_post_meta($course_id, '_lp_students', true);
		if( $student ) {
			$count = intval($student) + intval($student_fake);
		} else {
			$count = ( $users = get_post_meta( $course_id, '_lpr_course_user', true ) ) ? sizeof( $users ) : 0 + intval($student_fake) ;
		}	
		return apply_filters( 'learn_press_count_student_enrolled_course', $count, $course_id );
	}
}
remove_action( 'learn-press/before-checkout-form', 'learn_press_checkout_form_login', 5 );
remove_action( 'learn-press/before-checkout-form', 'learn_press_checkout_form_register', 10 );
if ( ! function_exists( 'flat_checkout_link_login_register' ) ) {
	function flat_checkout_link_login_register() {
		if ( is_user_logged_in() ) {
			return;
		}
		$redirect = wp_get_referer();
		$link_login    = flat_get_login_page_url() . '?redirect_to=' . esc_attr( $redirect );
		$link_register = flat_get_register_url() . '&redirect_to=' . esc_attr( $redirect );
		if ( LP()->checkout()->is_enable_login() || LP()->checkout()->is_enable_register() ) {
			
			if ( LP()->checkout()->is_enable_login() ) {
				echo '<div class="message message-notice"><i class="fa fa-info-circle" aria-hidden="true"> </i>';
				printf( esc_html__( ' If you have account, you can <a href="%1$s">login</a>. ', 'bookflare' ), esc_url( $link_login ) );
				echo '</div>';
			}
			if ( LP()->checkout()->is_enable_register() ) {
				echo '<div class="message message-notice"><i class="fa fa-info-circle" aria-hidden="true"> </i>';
				printf( esc_html__( ' Don\'t have an account? <a href="%1$s">Register here</a>.', 'bookflare' ), esc_url( $link_register ) );
				echo '</div>';
			}
			
		}
	}
}
add_action( 'learn-press/before-checkout-form', 'flat_checkout_link_login_register', 5 );