<?php
/**
 * Template for displaying course content within the loop
 *
 * @author  Themesflat
 * @package LearnPress/Templates
 * @version 3.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
	$course = LP()->global['course'];
	$course_id = get_the_ID();
	$course_item = LP_Course::get_course( $course_id );
	$columns = (int)themesflat_choose_opt('courses_columns')?(int)themesflat_choose_opt('courses_columns'):4;
	$course_style = themesflat_choose_opt('courses_style');
?>
<?php
	if( $course_style == "courses-grid" ){
		$courses_columns = 'col-xs-12 col-sm-6 col-md-'.esc_attr($columns).'';
	}else{
		$courses_columns = "col-xs-12 col-sm-12 col-md-12 one-column";
	}
?>
<div class="<?php echo esc_attr($courses_columns); ?> tflat-course-item style2 <?php themesflat_custom_course_price_color();  themesflat_category_slug(get_the_ID()); themesflat_tag_slug(get_the_ID()); ?>">
	<?php if ($course_style == "courses-grid") {
		learn_press_get_template('loop/course/loop-course-item.php');
	} else {
		learn_press_get_template('loop/course/loop-course-list-item.php');
	}?>
	
</div>