<?php
/**
 * Return the default options of the theme
 * 
 * @return  void
 */
function themesflat_customize_default_opt($key) {
	$default = array(

		'enable_preload'	  => 1,
		'enable_smooth_scroll'=>0,
		'key_google_api'	  => '',
		'key_google_map_api'  => '',
		'social_links'	=> array (	"facebook" => '#', 
									"twitter" => '#', 
									"instagram" => '#', 
									"pinterest" => '#'
								),
		'header_searchbox' => 0,
		'header_cartbox'   =>1,
		'header_style'     =>'v1',
		'enable_header_fullwidth' => 0,
		'logo_controls' => array('padding-top' => 31, 'padding-bottom' => 31),
		'logo_width'	=>'157',
		'logo_height'	=>'29',
		'topbar_enabled' => 0,
		'top_content' => '<ul><li class="phone">1 (800) 686-6688</li>
            	<li class="mail">contact@bookflare.com</li>
            </ul>',
        'enable_social_link'  => 0,
        'top_content_right' =>'<p class="inline-top">Enjoy A New Student Discount All <span class="font-Roboto font-weight-700 underline-text">55,000 Courses</span> on sale for <span class="font-Hall font-weight-700 letter-spaceing-top">Only </span> <span class="font-Playfair font-weight-700 letter-spaceing-top">$12.99 </span> </p>',
        'enable_connt_down'=>1,
        'cd_hour'=>'01/01/2019',
        'enable_lg_rg'=>1,
        'show_header_title_content'=> 1,
        'header_sticky' => 0,
        'site_logo' => THEMESFLAT_LINK . 'images/logo/logo.png',
        'site_retina_logo' =>  THEMESFLAT_LINK . 'images/logo/logo@2x.png',
        'footer_enable_botom'=>1,
        'footer_copyright' => '<p><a href="#">ThemesFlat</a> 2019. All rights reserved.</p>',
        'footer_enable_gotop'=>1,
        'footer_enable' =>1,
        'footer_enable_botom_menu'=>0,
        'footer_controls' => array('padding-top' => 97,'padding-bottom' => 94),
        'backgroud_footer' => THEMESFLAT_LINK . 'images/footer/background_footer.jpg',
        'body_background_img'=> '',
        'show_quickview'=>0,
        'call_back_bg_color_footer'=>'#000000',
        'bc_custom_opacity'=>'rgba(0,0,0,0)',
        'footer_widget_areas'	=> 3,
		'body_font_name'	=> array(
			'family' => 'Roboto',
			'style'  => '500',
			'size'   => '14',
			'line_height'=>'24'
			), 
		'headings_font_name'	=> array(
			'family' => 'Roboto',
			'style'  => '700'			
			),
		'h1_size' => 60,
		'h2_size' => 36,
		'h3_size' => 30,
		'h4_size' => 26,
		'h5_size' => 22,
		'h6_size' => 20,
		'menu_font_name'	=> array(
			'family' => 'Roboto',
			'style'  => '700',
			'size'   => '14',
			'line_height'=>'93',
			),
		'body_text_color'=>'#515e6f',
		'hover_body_color'	=>	'#f3728b',
		'top_background_color' =>'#192836',
		'topbar_textcolor'  =>'#ffffff',
		'topbar_textcolorcd' =>'#ffffff',
		'top_background_colorcd' =>'#fa778a',
		'mainnav_backgroundcolor' =>'#ffffff',
		'mainnav_color'=>'#192836',
		'mainnav_hover_background'=>'rgba(242,194,26,0)',
		'mainnav_hover_color' =>'#f3728b',
		'border_color_sub_nav'=>'rgba(25,40,54,0.1)',
		'background_color_sub_nav'=>'rgba(25, 40, 54, 0.05)',
		'footer_text_color_title' =>'#ffffff',
		'footer_text_color' =>'#ffffff',
		'bottom__background_color' =>'#15222e',
		'bottom_text_color' =>'#718297',
		'scheme_color'=>'#f3728b',
		'custom_cb'=>0,
		'custom_cb_text1'=>'80,000 ONLINE COURSES',
		'custom_cb_icon1'=>'<span class="icon-book"></span>',
		'custom_cb_text2'=>'EXPERT INSTRUCTION',
		'custom_cb_icon2'=>'<span class="icon-people"></span>',
		'custom_cb_text3'=>'LIFETIME ACCESS',
		'custom_cb_icon3'=>'<span class="icon-key"></span>',
		'custom_cb_color_icon'=>'#ffffff',
		'custom_cb_color_text'=>'#ffffff',
		'custom_cb_background'=>THEMESFLAT_LINK . 'images/feature/bg-feature-2.png',
		'page_title_style_breadcrumb' =>'style_page_title_1',
		'show_page_title'=>0,
		'show_page_title_heading'=> 1,
		'breadcrumb_enabled'=>0,
		'page_title_background_image'=>THEMESFLAT_LINK . 'images/page-title/page-title.jpg',
		'page_title_text_color'=>'#ffffff',
		'page_title_link_color'=>'#ffffff',
		'page_title_overlay_color'=>'rgba(25,40,54,0.5)',
		'page_title_controls' => array('padding-top' => 94, 'padding-bottom' => 94),
		'show_parallax_page_title'=>0,
		'position_page_title'=>1,
		'bread_crumb_prefix' =>'',
		'breadcrumb_separator' =>  '<i class="fa fa-angle-double-right" aria-hidden="true"></i>',
		'page_title_textarea'=>'',
		'layout_version'	=> 'wide',	
		'body_background_color'=>'#ffffff',
		'page_layout' => 'fullwidth',
		'blog_layout' => 'sidebar-right',
		'courses_style'=>'courses-grid',
		'page_sidebar_list'	=> 'sidebar-page',
		'show_post_meta'	=> 1,
		'blog_archive_readmore' => 1,
		'blog_archive_readmore_text' => 'Read More',
		'blog_archive_layout' => 'blog-list',
		'blog_sidebar_list'		  => 'sidebar-blog',
		'blog_archive_post_excepts_length' => 57,
		'blog_archive_pagination_style' => 'pager-numeric',
		'related_post_style'	=> 'blog-grid',
		'show_post_navigator' => 0,
		'show_share_link'=> 0,
		'show_author_post'=> 0,
		'show_related_post' =>0,
		'social_link_share_single'	=> array (	"facebook" => 'https://www.facebook.com/sharer.php?u=', 
									"twitter" => 'https://twitter.com/intent/tweet?url=',  
									"google-plus" => 'https://plus.google.com/share?url='
								),
		'courses_layout' => 'sidebar-right',
		'courses_columns' => '4',
		'courses_archive_post_excepts_length' => 20,
		'excerpt_more_courses' => '...',
		'courses_archive_excerpt'=>1,
		'courses_tab_iso'		=>0,
		'show_columns'	=> '4',
		'number_post_page_prduct'	=>	9,
		'number_post_relate_prduct'=>3,
		'show_columns_relate' =>'4',
		'show_relate_shop'=>1,
		'freemonth_courses_single'=> '',
		'content_ft_single'	=>'<h1 class="title"><a href="#">Start My Free Month!</a></h1>
                        <p class="description">We offer professional SEO services that help websites <a href="#" class="link-site">increase their organic search</a> score <br/>drastically in order to compete for the highest rankings.</p>
                        <div class="wrap-btn">
                            <a href="#" class="flat-button btn-start border-ra4">START MY FREE MONTH</a>
                        </div>',
		'background_footer_single_courses' => THEMESFLAT_LINK . 'images/footer/bg-free-month-bk.jpg',
		'page_content_controls_default'=>'',
	);
	return $default[$key];
}
/**
 * Return an array that used to declare options
 * for the page
 * 
 * @return  array
 */

/*Teacher meta*/
function themesflat_teacher_options_fields(){
	$options['cover_heading'] = array(
		'type' => 'heading',
		'section' => 'general',
		'title' => esc_html__( 'Teacher', 'bookflare' )
	);
	
	$options['link_fb'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Profile FB', 'bookflare' ),
		'default' => '#'
	);
	$options['link_skyper'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Skyper username', 'bookflare' ),
		'default' => '#'
	);
	$options['link_intagram'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Profile Intagram', 'bookflare' ),
		'default' => '#'
	);
	$options['link_github'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Github link', 'bookflare' ),
		'default' => '#'
	);
	themesflat_prepare_options($options);
	return $options;
}

/* Course meta*/
function themesflat_course_options_fields(){
	$options['cover_heading'] = array(
		'type' => 'heading',
		'section' => 'general',
		'title' => esc_html__( 'Event', 'bookflare' )
	);
	themesflat_prepare_options($options);
	return $options;
}
/* Event meta*/
function themesflat_event_options_fields(){
	$options['cover_heading'] = array(
		'type' => 'heading',
		'section' => 'general',
		'title' => esc_html__( 'Event', 'bookflare' )
	);
	$options['location_map'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Location Map', 'bookflare' ),
		'default' => ''
	);
	$options['time_event'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Time Even (mm/dd/yyyy)', 'bookflare' ),
		'default' => ''
	);
	$options['start_time'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Start', 'bookflare' ),
		'default' => ''
	);
	$options['end_time'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'End Time', 'bookflare' ),
		'default' => ''
	);
	$options['total_slot'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'TOTAL SLOT', 'bookflare' ),
		'default' => ''
	);
	$options['cost_event'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'COST', 'bookflare' ),
		'default' => ''
	);
	$options['id_ticket'] = array(
		'type'    => 'text',
		'section' => 'general',
		'title' => esc_html__( 'Get form ticket by ID in contact form 7', 'bookflare' ),
		'default' => ''
	);
	$options['show_page_title'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Page Title', 'bookflare' ),
		'section' => 'page_title',
		'children' => array('page_title_style_breadcrumb','page_title_background_image','pagetitle_padding','position_page_title','page_title_textarea','show_parallax_page_title','page_title_controls','page_title_link_color','page_title_text_color','page_title_overlay_color'),
		'default' =>  false
	);
	$options['page_title_style_breadcrumb'] = array(
		'type'      => 'radio-images',   
            'section'   => 'page_title',
            'label'         => esc_html__('Click the page style for your website', 'bookflare'),
            'choices'   => array (
                'style_page_title_1'=> array (
                   'tooltip'   => esc_html__('Page title Type1','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle2.jpg'
                ) ,
                'style_page_title_2'=>  array (
                   'tooltip'   => esc_html__('Page title Type2','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle1.jpg'
                ) ,
            ),
        'default' => themesflat_customize_default_opt('page_title_style_breadcrumb') ,
	);
	$options['page_title_background_image'] = array(
		'type' => 'single-image-control',
		'title'   => esc_html__( 'Page Title Background Image', 'bookflare' ),
		'section' => 'page_title',
		'default' => themesflat_customize_default_opt('page_title_background_image')
	);

	$options['position_page_title'] = array(
		'type'      => 'select',     
		'title'   => esc_html__( 'Select position page title', 'bookflare' ),      
            'section'   => 'page_title',
            'priority'  => 5,
            'label'     => esc_html__('Select position page title', 'bookflare'),
            'choices'   => array(                
                1     => esc_html__( 'Left', 'bookflare' ),
                2     => esc_html__( 'Right', 'bookflare' ),
                3     => esc_html__( 'Center', 'bookflare' ),               
            ),
            'default'           => themesflat_customize_default_opt('position_page_title'),
	);
	$options['page_title_textarea'] = array(
		'type'      => 'textarea',     
		'title'   => esc_html__( 'Sub of Title Page', 'bookflare' ),      
        'section'   => 'page_title',
       	'type' => 'textarea',
        'default'           => themesflat_customize_default_opt('page_title_textarea'),
	);
	$options['show_parallax_page_title'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable parallax page img title', 'bookflare' ),
		'section' => 'page_title',
		'default' =>  themesflat_customize_default_opt('show_parallax_page_title'),
	);
	$options['page_title_text_color'] = array(
		'type'    => 'color-picker',     
		'title'   => esc_html__( 'Page Heading Text Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_text_color'),
	);
	$options['page_title_link_color'] = array(
		'type'    => 'color-picker',     
		'title'   => esc_html__( 'Breadcrumb Text Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_link_color'),
	);
	$options['page_title_overlay_color'] = array(
		'type'    => 'alpha-color',
		'title'   => esc_html__( 'Opacity = 0.5 for Background Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_overlay_color'),
	);
 	$options['page_title_controls'] = array(
		'type'    => 'box-controls',		
		'title'   => esc_html__( 'Enable Custom box controls', 'bookflare' ),
		'section' => 'page_title',
		'default' => themesflat_customize_default_opt('page_title_controls'),
	);
	themesflat_prepare_options($options);
	return $options;
}
/*Post Meta*/
function themesflat_post_options_fields() {
	$options['blog_heading'] = array(
		'type' => 'heading',
		'section' => 'blog',
		'title' => esc_html__( 'Dear friends,', 'bookflare' )
	);
	$options['gallery_images_heading'] = array(
		'type' => 'heading',
		'section' => 'blog',
		'title' => esc_html__( 'Post Format: Gallery .', 'bookflare' ),
		'description' => esc_html__( '', 'bookflare' )
	);
	$options['gallery_images'] = array(
		'type'    => 'image-control',
		'section' => 'blog',
		'title' => esc_html__( 'Images', 'bookflare' ),
		'default' => ''
	);
	$options['video_url_heading'] = array(
		'type' => 'heading',
		'section' => 'blog',
		'title' => esc_html__( 'Post Format: Video ( Embeded video from youtube, vimeo ...).', 'bookflare' ),
		'description' => esc_html__( '', 'bookflare' )
		);

	$options['video_url'] = array(
		'type'    => 'textarea',
		'section' => 'blog',
		'title' => esc_html__( 'iframe video link', 'bookflare' ),
		'default' => ''
		);
	themesflat_prepare_options($options);
	return $options;
}
function themesflat_page_options_fields() {
	global $wp_registered_sidebars;
	$options  = array();
	$sidebars = array();
	// Retrieve all registered sidebars
	foreach( $wp_registered_sidebars as $params )
		$sidebars[$params['id']] = $params['name'];
	/**
	 * Header
	 */
	
	$options['show_page_layout'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Custom Page', 'bookflare' ),
		'section' => 'general',
		'children' => array('show_header_title_content','page_layout','page_sidebar_list','body_background_img','page_content_controls_default'),
		'default' =>  false,
		'priority'  => 1,
	);
	$options['show_header_title_content'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Show Heading Content Page Default', 'bookflare' ),
		'section' => 'general',
		'default' => themesflat_customize_default_opt('show_header_title_content')
	);
	$options['page_layout'] = array(
		'type'      => 'select',     
		'title'   => esc_html__( 'Select position page layout', 'bookflare' ),      
            'section'   => 'general',
            'priority'  => 1,
            'title' => esc_html__( 'Select position page layout', 'bookflare' ),
            'label'     => esc_html__('Select position page layout', 'bookflare'),
            'choices'   => array (
                'sidebar-right' =>  esc_html__( 'Sidebar Right','bookflare' ),
                'sidebar-left'=>   esc_html__( 'Sidebar Left','bookflare' ),
                'fullwidth'=>   esc_html__( 'Full Width','bookflare' ),           
            ),
            'default'           => themesflat_customize_default_opt('page_layout'),
	);
	$options['page_sidebar_list'] = array(
		'type'      => 'dropdown-sidebar',     
		'title'   => esc_html__( 'Select position page layout', 'bookflare' ),      
        'section'   => 'general',
        'priority'  => 2,
        'label'     => esc_html__('Select position page layout', 'bookflare'),
        'default'           => themesflat_customize_default_opt('page_sidebar_list'),
	);
	$options['body_background_img'] = array(
		'type'    => 'single-image-control',
		'title'   => esc_html__( 'Background Images Body', 'bookflare' ),
		'section' => 'general',
		'default' => '',
	);
	$options['page_content_controls_default'] = array(
		'type' => 'box-controls',
		'title'   => esc_html__( 'Page Content Controls Default(px)', 'bookflare' ),
		'section' => 'general',
		'default' =>themesflat_customize_default_opt('page_content_controls_default'),
		);
	
	$options['topbar_heading'] = array(
		'type' => 'heading',
		'section' => 'header',
		'title' => esc_html__( 'Top Bar', 'bookflare' ),
		'description' => esc_html__( 'Turn on/off the top bar and change it styles.', 'bookflare' )
	);
	$options['topbar_enabled'] = array(
		'type'    => 'power',
		'title'   => esc_html__( 'Custom Topbar', 'bookflare' ),
		'section' => 'header',
		'children' => array('topbar_textcolor','top_background_color'),
		'default' => false
	);
	$options['top_background_color'] = array(
		'type'    => 'color-picker',
		'title'   => esc_html__( 'Topbar Background Color', 'bookflare' ),
		'section' => 'header',
		'default' => themesflat_get_opt('top_background_color' )
	);
	$options['topbar_textcolor'] = array(
	  'type'    => 'color-picker',
	  'title'   => esc_html__( 'Topbar Color', 'bookflare' ),
	  'section' => 'header',
	  'default' => themesflat_get_opt( 'topbar_textcolor')
	);
	$options['header_style_heading'] = array(
		'type'        => 'heading',
		'section'     => 'header',
		'title'       => esc_html__( 'Custom Header', 'bookflare' ),
		'description' => esc_html__( 'Change header style on/off ', 'bookflare' )
	);
	$options['enable_custom_header_style'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Custom Header', 'bookflare' ),
		'section' => 'header',
		'children' => array('header_sticky','header_show_offcanvas','header_style','body_background_color','site_logo','site_retina_logo'),
		'default' => false
	);
	
	$options['body_background_color'] = array(
		'type'    => 'alpha-color',
		'title'   => esc_html__( 'Background Color Body', 'bookflare' ),
		'section' => 'header',
		'default' =>  themesflat_customize_default_opt('body_background_color'),
	);
	$options['header_style'] = array(
        'type'      => 'radio-images',           
        'section'   => 'header',       
        'title'   => esc_html__( 'List Header Type', 'bookflare' ), 
        'label'         => esc_html__('List Header Type', 'bookflare'),
		
        'choices'   => array (
            'v1'=> array (
               'tooltip'   => esc_html__('Header Type1','bookflare'),
               'src'       => THEMESFLAT_LINK . 'images/header/header.png'
            ) ,
            'v2'=>  array (
               'tooltip'   => esc_html__('Header Type2','bookflare'),
               'src'       => THEMESFLAT_LINK . 'images/header/header-2.png'
            ) ,
        ),
        'default' => themesflat_customize_default_opt('header_style'),
    );
	$options['site_logo'] = array(
		'type' => 'single-image-control',
		'title'   => esc_html__( 'Logo', 'bookflare' ),
		'section' => 'header',
		'default' => themesflat_customize_default_opt('site_logo'),
	);
	$options['site_retina_logo'] = array(
		'type' => 'single-image-control',
		'title'   => esc_html__( 'Logo Retina', 'bookflare' ),
		'section' => 'header',
		'default' => themesflat_customize_default_opt('site_retina_logo'),
	);
    $options['header_sticky'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable sticky header', 'bookflare' ),
		'section' => 'header',
		'default' => themesflat_customize_default_opt('header_sticky')
	);
    
    /**
	 * Page Title
	 */
	$options['show_page_title_cs'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Custom Page Title', 'bookflare' ),
		'section' => 'page_title',
		'children' => array('show_page_title','show_page_title_heading','page_title_style_breadcrumb','page_title_background_image','show_parallax_page_title','pagetitle_padding','position_page_title','page_title_textarea','page_title_controls','page_title_link_color','page_title_text_color','page_title_overlay_color'),
		'default' =>  false
	);
	$options['show_page_title'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Page Title', 'bookflare' ),
		'section' => 'page_title',
		'default' =>  themesflat_customize_default_opt('show_page_title'),
	);
	$options['show_page_title_heading'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Title Heading ', 'bookflare' ),
		'section' => 'page_title',
		'default' =>  themesflat_customize_default_opt('show_page_title_heading'),
	);
	$options['page_title_style_breadcrumb'] = array(
		'type'      => 'radio-images',   
            'section'   => 'page_title',
            'label'         => esc_html__('Click the page style for your website', 'bookflare'),
            'choices'   => array (
                'style_page_title_1'=> array (
                   'tooltip'   => esc_html__('Page title Type1','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle2.jpg'
                ) ,
                'style_page_title_2'=>  array (
                   'tooltip'   => esc_html__('Page title Type2','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle1.jpg'
                ) ,
            ),
        'default' => themesflat_customize_default_opt('page_title_style_breadcrumb') ,
	);
	$options['page_title_background_image'] = array(
		'type' => 'single-image-control',
		'title'   => esc_html__( 'Page Title Background Image', 'bookflare' ),
		'section' => 'page_title',
		'default' => ''
	);

	$options['position_page_title'] = array(
		'type'      => 'select',     
		'title'   => esc_html__( 'Select position page title', 'bookflare' ),      
            'section'   => 'page_title',
            'priority'  => 5,
            'label'     => esc_html__('Select position page title', 'bookflare'),
            'choices'   => array(                
                1     => esc_html__( 'Left', 'bookflare' ),
                2     => esc_html__( 'Right', 'bookflare' ),
                3     => esc_html__( 'Center', 'bookflare' ),               
            ),
            'default'           => themesflat_customize_default_opt('position_page_title'),
	);
	$options['page_title_textarea'] = array(
		'type'      => 'textarea',     
		'title'   => esc_html__( 'Sub of Title Page', 'bookflare' ),      
        'section'   => 'page_title',
       	'type' => 'textarea',
        'default'           => themesflat_customize_default_opt('page_title_textarea'),
	);
	$options['show_parallax_page_title'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable parallax page img title', 'bookflare' ),
		'section' => 'page_title',
		'default' =>  themesflat_customize_default_opt('show_parallax_page_title'),
	);
	$options['page_title_text_color'] = array(
		'type'    => 'color-picker',     
		'title'   => esc_html__( 'Page Heading Text Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_text_color'),
	);
	$options['page_title_link_color'] = array(
		'type'    => 'color-picker',     
		'title'   => esc_html__( 'Breadcrumb Text Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_link_color'),
	);
	$options['page_title_overlay_color'] = array(
		'type'    => 'alpha-color',
		'title'   => esc_html__( 'Opacity = 0.5 for Background Color', 'bookflare' ),      
        'section'   => 'page_title',
        'default'   => themesflat_customize_default_opt('page_title_overlay_color'),
	);
 	$options['page_title_controls'] = array(
		'type'    => 'box-controls',		
		'title'   => esc_html__( 'Enable Custom box controls', 'bookflare' ),
		'section' => 'page_title',
		'default'           => themesflat_customize_default_opt('page_title_controls'),
	);

	//footer
	$options['footer_cs'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Custom Footer', 'bookflare' ),
		'section' => 'footer',
		'children' => array('custom_cb','footer_enable'),
		'default' =>  false
	);
	$options['custom_cb'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Footer Expert Instruction', 'bookflare' ),
		'section' => 'footer',
		'default' => themesflat_customize_default_opt('custom_cb'),
	);
	$options['footer_enable'] = array(
		'type'    => 'power',		
		'title'   => esc_html__( 'Enable Footer widget', 'bookflare' ),
		'section' => 'footer',
		'default' => themesflat_customize_default_opt('footer_enable'),
	);

	themesflat_prepare_options($options);
	return $options;
}
function themesflat_get_children($ar){
	if (isset($ar['children'])){
	 return $ar['children'];
	}
}
function themesflat_prepare_options($options) {
	$flat_data = get_option('flatopts');
	$flatopts = array();
	if(!is_array($flat_data)) $flat_data = array();
	$children = array_map('themesflat_get_children', $options);
	$children = array_filter($children);
	foreach ($children as $key => $value) {
		if (is_array($value)) {
			foreach ($value as $_key => $_value) {
				$flatopts[$_value] = $key;
			}
		}
		else {
			$flatopts[$value] = $key;
		}
	}
	$flat_data = array_merge($flat_data,$flatopts);
	update_option('flatopts',$flat_data);
}