<?php
/**
 * themesflat functions and definitions
 *
 * @package bookflare
 */
define( 'THEMESFLAT_DIR', trailingslashit( get_template_directory() )) ;
define( 'THEMESFLAT_LINK', trailingslashit( get_template_directory_uri() ) );
define( 'THEMESFLAT_ICON', THEMESFLAT_LINK.'images/logo/logoflat.png' );
define( 'PROTOCOL' , (is_ssl()) ? 'https' : 'http' );
if ( ! function_exists( 'themesflat_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */

function themesflat_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on burger, use a find and replace
	 * to change 'bookflare' to the name of your theme in all the template files
	 */

	load_theme_textdomain( 'bookflare', THEMESFLAT_DIR . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Content width
	global $content_width;
	if ( ! isset( $content_width ) ) {
		$content_width = 1170; /* pixels */
	}	

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );	
	
	
	add_image_size( 'themesflat-event-list-shortcode', 952,633, true );
	add_image_size( 'themesflat-courser-single-courser-teacher', 122, 110, true );
	add_image_size( 'themesflat-courser-grid-simple', 730, 286, true );
	add_image_size( 'themesflat-portfolio-grid', 750, 750, true );
	add_image_size( 'themesflat-recent-news-thumb', 144, 152, true );
	add_image_size( 'themesflat-courser-grid-short', 654, 404, true );
	add_image_size( 'themesflat-courser-grid-simple2', 530, 435, true );
	add_image_size( 'themesflat-shop-quick-view', 483, 570, true );
	add_image_size( 'themesflat-shop-sinle-view', 675, 675, true );
	add_image_size( 'themesflat-courser-shortcode', 560, 400, true );
	add_image_size( 'themesflat-blog', 1170, 675, true );
	add_image_size( 'themesflat-courser-grid-carosel', 578, 354, true );

	//Get thumbnail url
	function themesflat_thumbnail_url($size){
	    global $post;
	    if( $size== '' ) {
	        $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
	        return esc_url($url);
	    } else {
	        $url = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), $size);
	        return esc_url($url[0]);
	    }
	}

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Menu', 'bookflare' ),
		'footer' => esc_html__( 'Footer Menu', 'bookflare' ),
		'bottom' => esc_html__( 'Bottom Menu', 'bookflare' )
	) );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'gallery', 'video', 'quote', 'link',
	) );

	// Set up the WordPress core custom background feature.
	$args = array(
		'default-color' => 'ffffff',
		'default-image' => '',
	);

	add_theme_support( 'custom-background', $args );

	// Custom stylesheet to the TinyMCE visual editor
	function themesflat_add_editor_styles() {
	    add_editor_style( 'css/editor-style.css' );
	}
	add_action( 'admin_init', 'themesflat_add_editor_styles' );	
}
endif; // themesflat_setup

add_action( 'after_setup_theme', 'themesflat_setup' );

function themesflat_wpfilesystem() {
	include_once (ABSPATH . '/wp-admin/includes/file.php');
	WP_Filesystem();
}

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function themesflat_widgets_init() {
	//Sidebar for Blog
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'bookflare' ),
		'id'            => 'sidebar-blog',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'bookflare' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	//Sidebar footer
	register_sidebar( array(
        'name'          => esc_html__( 'Footer area 1', 'bookflare' ),
        'id'            => 'footer-1',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Footer1.', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer area 2', 'bookflare' ),
        'id'            => 'footer-2',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Footer2.', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer area 3', 'bookflare' ),
        'id'            => 'footer-3',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Footer3.', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );  

    register_sidebar( array(
        'name'          => esc_html__( 'Footer custom menu', 'bookflare' ),
        'id'            => 'fb-custom-menu',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Footer custom menu.', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );    
  
	/*Sidebar Woocommerce Shop*/
	register_sidebar( array(
        'name'          => esc_html__( 'Woocommerce Shop Sidebar', 'bookflare' ),
        'id'            => 'themesflat-woocommerce-sidebar',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Woocommerce', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    /*Sidebar Courses*/
	register_sidebar( array(
        'name'          => esc_html__( 'Course Sidebar', 'bookflare' ),
        'id'            => 'themesflat-courses-sidebar',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar Course', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Event', 'bookflare' ),
        'id'            => 'themesflat-event-sidebar',
        'description'   => esc_html__( 'Add widgets here to appear in your Event count down', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Courses Page Custom', 'bookflare' ),
        'id'            => 'themesflat-coutrses-sidebar',
        'description'   => esc_html__( 'Add widgets here', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Subscribe Newslatter', 'bookflare' ),
        'id'            => 'themesflat-newslatter',
        'description'   => esc_html__( 'Add widgets here', 'bookflare' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
		'name'          => esc_html__( 'Page Sidebar', 'bookflare' ),
		'id'            => 'sidebar-page',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'bookflare' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'themesflat_widgets_init' );

/**
 * Load the front page widgets.
 */

require THEMESFLAT_DIR . "inc/options/options-definition.php";
require_once(THEMESFLAT_DIR .'inc/options/controls/dropdown-sidebars.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/typography.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/radio-images.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/color_overlay.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/check-box.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/social_icons.php');
require_once(THEMESFLAT_DIR .'inc/options/controls/box-control.php');

function themesflat_get_style($style) {
	return str_replace('italic', 'i', $style);
}
if (!function_exists('themesflat_filtercontent')) {
	function themesflat_filtercontent($variable){
		return $variable;
 	}
}

function themesflat_fonts_url() {
    $fonts_url = '';
    $body_font_name =  themesflat_get_json('body_font_name');
    $headings_font_name = themesflat_get_json('headings_font_name');
    $menu_font_name = themesflat_get_json('menu_font_name');
    $font_families = array(); 

    if ( '' != $body_font_name ) {
        $font_families[] = $body_font_name['family'].':100,100i,300,300i,400,400i,500,500i,700,700i,'.themesflat_get_style($body_font_name['style']);
        $font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
        $font_families[] = 'Noto+Serif:400,400i,700,700i';
    } else {
    	$font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
    }    

    if ( '' != $headings_font_name ) {
        $font_families[] = $headings_font_name['family'].':100,100i,300,300i,400,400i,500,500i,700,700i,'.themesflat_get_style($headings_font_name['style']);
        $font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
    }

     else {
    	$font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
    }    

    if ( '' != $menu_font_name ) {
        $font_families[] = $menu_font_name['family'].':'.themesflat_get_style($menu_font_name['style']);
        $font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
    } else {
    	$font_families[] = 'Poppins:400,400i,500,500i,600,600i,700,700i,800,800i';
    }    
    
    $query_args = array(
        'family' => urlencode( implode( '|', $font_families ) ),        
    );

    $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

    return esc_url_raw( $fonts_url );
}

function themesflat_scripts_styles() {
    wp_enqueue_style( 'themesflat-theme-slug-fonts', themesflat_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'themesflat_scripts_styles' );
/**
 * Enqueue scripts and styles.
 */

function themesflat_scripts() {

	// Theme stylesheet.
	wp_enqueue_style( 'fontawesome', THEMESFLAT_LINK . 'css/font-awesome.min.css' );
	wp_enqueue_style( 'elegant', THEMESFLAT_LINK . 'css/font-elegant.css' );
	wp_enqueue_style( 'ionicons', THEMESFLAT_LINK . 'css/ionicons.min.css' );	
	wp_enqueue_style( 'flexslider', THEMESFLAT_LINK . 'css/flexslider.css' );
	wp_enqueue_style( 'animate', THEMESFLAT_LINK . 'css/animate.css' );	
	wp_enqueue_style( 'dashicons' );
	wp_enqueue_style( 'liblary', THEMESFLAT_LINK . 'css/liblary.css' );	
	wp_enqueue_style( 'shortcode', THEMESFLAT_LINK . 'css/shortcode.css' );	
	wp_enqueue_style( 'bf_icon', THEMESFLAT_LINK . 'css/bf-icon.css' );	
	wp_enqueue_style( 'freestyle-font', THEMESFLAT_LINK . 'css/freestyle-font.css' );	
	wp_enqueue_style( 'carousel', THEMESFLAT_LINK . 'css/owl.carousel.css' );	
	wp_enqueue_style( 'woocommerce', THEMESFLAT_LINK . 'css/woocommerce.css' );	
	wp_enqueue_style( 'course-review-icon', THEMESFLAT_LINK . 'css/course-review-icon.css' );
	wp_enqueue_style( 'themesflat-main', THEMESFLAT_LINK . 'css/main.css' );
	wp_enqueue_style( 'themesflat-style', get_stylesheet_uri() );
	wp_enqueue_style( 'responsive', THEMESFLAT_LINK . 'css/responsive.css' );
	
	// Load the html5 shiv..	
	wp_enqueue_script( 'jquery-easing', THEMESFLAT_LINK . 'js/jquery.easing.js', array('jquery'),'1.3' ,true);		
	wp_enqueue_script( 'match', THEMESFLAT_LINK . 'js/matchMedia.js', array(),'1.2',true);
	wp_enqueue_script( 'popup', THEMESFLAT_LINK . 'js/jquery.magnific-popup.min.js', array(),'1.1',true);
	wp_enqueue_script( 'carousel', THEMESFLAT_LINK . 'js/owl.carousel.js', array(),'1.1',true);
	wp_enqueue_script( 'parallax', THEMESFLAT_LINK . 'js/parallax.js', array(),'1.1',true);
	wp_enqueue_script('imagesloaded', array(),'3.2.0',true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply', array(),'2.0.4',true );
	}
	if ( class_exists( 'WooCommerce' ) ){
		wp_enqueue_script( 'jquery-ui-autocomplete' );
	}
	wp_enqueue_script( 'themesflat-bookflare-map-ACF', THEMESFLAT_LINK . 'js/map-ACF.js', array(),'3',true);
	// Load the main js
	wp_enqueue_script( 'themesflat-bookflare-scripts', THEMESFLAT_LINK . 'js/main.js', array(),'2.0.4',true);
	wp_localize_script( 'themesflat-bookflare-scripts', 'the_ajax_script', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	// Smooth Scroll
	if(themesflat_get_opt('enable_smooth_scroll') == 1){
		wp_enqueue_script( 'SmoothScroll', THEMESFLAT_LINK . 'js/SmoothScroll.js', array(),'1.0.0',true);
	}
	
}
add_action( 'wp_enqueue_scripts', 'themesflat_scripts' );

function themesflat_load_customizer_style() {   
    wp_enqueue_style( 'themesflat_customizer_css', THEMESFLAT_LINK .'css/admin/customizer.css', false, '1.0.0' );
    wp_enqueue_style( 'themesflat-color-alpha-css', THEMESFLAT_LINK .'css/admin/color_alpha.css', false, '1.0.0' );
	wp_enqueue_script( 'themesflat-color-alpha', THEMESFLAT_LINK . 'js/wp-color-picker-alpha.js', array('wp-color-picker'),'1.1',true);
    wp_enqueue_script( 'choosen',THEMESFLAT_LINK .'js/admin/3rd/chosen.jquery.min.js',array( 'jquery'),'',true );
    wp_enqueue_script( 'themesflat_customizer_js',THEMESFLAT_LINK .'js/admin/customizer.js',array( 'jquery','customize-preview' ),'',true);
    wp_enqueue_style( 'choosen', THEMESFLAT_LINK . 'css/chosen.css', array(), true );
}
add_action( 'admin_enqueue_scripts', 'themesflat_load_customizer_style' );
function themesflat_render_style($class,$custom_string=''){
    $css = esc_attr($class) .'{';
    if (is_array($custom_string)) {
        foreach ($custom_string as $key => $value) {
            if ( $value !='') {
                $css .= esc_attr($key) .':'.esc_attr($value);
            }
        }
    }
    else {
        $css .= esc_attr($custom_string);
    }
    $css .= '}';
    add_action( 'wp_enqueue_scripts', 'themesflat_add_custom_styles',10,$css );
}
function themesflat_add_custom_styles($custom) {
    wp_add_inline_style( 'themesflat-style', '.testimagebox{}' );
} 
function themesflat_shortcode_icon_name( $prefix,$icon_type ) {
    $icon_name = '';
    if ($icon_type != 'none') {
        $icon_name  = $prefix.$icon_type;
        wp_enqueue_style('vc_'.$icon_type);
    }
    return $icon_name;
}
/**
 * Enqueue Backend and Frontend CSS Styles
 */
add_action( 'vc_backend_editor_enqueue_js_css', 'themesflat_vc_iconpicker_editor_jscss' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'themesflat_vc_iconpicker_editor_jscss' );
function themesflat_vc_iconpicker_editor_jscss(){
    wp_enqueue_style( 'vc_simpleline' );
    wp_enqueue_style( 'vc_ionicons' );
}

add_theme_support( "custom-header");
/**
 * Enqueue Bootstrap
 */
function themesflat_enqueue_bootstrap() {
	wp_enqueue_style( 'bootstrap', THEMESFLAT_LINK . 'css/bootstrap.css', array(), true );
}
add_action( 'wp_enqueue_scripts', 'themesflat_enqueue_bootstrap', 9 );


// Customizer additions.
require THEMESFLAT_DIR . 'inc/customizer.php';

// Revo Slider
require THEMESFLAT_DIR . 'inc/revo-slider.php';

// metabox-options
require THEMESFLAT_DIR . "inc/js_composer.php";
// Helpers
require THEMESFLAT_DIR . 'inc/helpers.php';
// Struct
require THEMESFLAT_DIR . 'inc/structure.php';

// Breadcrumbs additions.
require THEMESFLAT_DIR . 'inc/breadcrumb.php';

// Pagination additions.
require THEMESFLAT_DIR . 'inc/pagination.php';

// Custom template tags for this theme.
require THEMESFLAT_DIR . 'inc/template-tags.php';

// Style.
require THEMESFLAT_DIR . 'inc/styles.php';

/*Woocommerce*/
if (class_exists('Woocommerce')){
	require_once THEMESFLAT_DIR . 'woocommerce/init.php';
}
// Required plugins
require_once THEMESFLAT_DIR . 'inc/plugins/class-tgm-plugin-activation.php';

// Plugin Activation
require_once THEMESFLAT_DIR . 'inc/plugins/plugins.php';

require_once THEMESFLAT_DIR . 'sampledata/sample-data.php';

/*Learn Press*/
if ( class_exists( 'LearnPress' ) ) {
	require_once THEMESFLAT_DIR . '/learnpress/lp-template-functions.php';
	require_once THEMESFLAT_DIR . '/learnpress/lp-template-hooks.php';
}

if ( ! function_exists( 'wpdocs_my_search_form' ) ) {
function wpdocs_my_search_form( $form ) {
	$style = '';
	if(is_home()){
		$style = 'v2';
	}

    $form = '<form role="search" method="get" id="searchform" class="searchform '.esc_attr($style).'" action="' . home_url( '/' ) . '" >
    <div>
    <input type="text" value="' . get_search_query() . '" placeholder="'.esc_attr__( 'Search', 'bookflare' ).'" name="s" id="s" />
    <button class="btn-search flat-button search-submit"><i class="fas fa-search"></i></button>
    </div>
    </form>';
 
    return $form;
	}
}
add_filter( 'get_search_form', 'wpdocs_my_search_form',10, 1  );

function wcr_category_fields($term) {
    // we check the name of the action because we need to have different output
    // if you have other taxonomy name, replace category with the name of your taxonomy. ex: book_add_form_fields, book_edit_form_fields
    if (current_filter() == 'category_edit_form_fields') {
        $code_icon = get_term_meta($term->term_id, 'code_icon', true);
        ?>
        <tr class="form-field">
            <th valign="top" scope="row"><label for="term_fields[code_icon]"><?php esc_html_e('Code icon','bookflare'); ?></label></th>
            <td>
                <input type="text" size="40" value="<?php echo esc_attr($code_icon); ?>" id="term_fields[code_icon]" name="term_fields[code_icon]"><br/>
            </td>
            <p class="description"><?php esc_html_e('Please check code icon in here https://fontawesome.com/v4.7.0/icons/','bookflare'); ?></p>
        </tr>   
	<?php } elseif (current_filter() == 'category_add_form_fields') {
        ?>
        <div class="form-field">
            <label for="term_fields[code_icon]"><?php esc_html_e('Code icon','bookflare'); ?></label>
            <input type="text" size="40" value="" id="term_fields[code_icon]" name="term_fields[code_icon]">
             <p class="description"><?php esc_html_e('Please check code icon in here https://fontawesome.com/v4.7.0/icons/','bookflare'); ?></p>
        </div>  
    <?php
    }
}

// Add the fields, using our callback function  
// if you have other taxonomy name, replace category with the name of your taxonomy. ex: book_add_form_fields, book_edit_form_fields
add_action('category_add_form_fields', 'wcr_category_fields', 10, 2);
add_action('category_edit_form_fields', 'wcr_category_fields', 10, 2);

function wcr_save_category_fields($term_id) {
    if (!isset($_POST['term_fields'])) {
        return;
    }

    foreach ($_POST['term_fields'] as $key => $value) {
        update_term_meta($term_id, $key, sanitize_text_field($value));
    }
}

// Save the fields values, using our callback function
// if you have other taxonomy name, replace category with the name of your taxonomy. ex: edited_book, create_book
add_action('edited_category', 'wcr_save_category_fields', 10, 2);
add_action('create_category', 'wcr_save_category_fields', 10, 2);

?>