<?php
/**
 * @package bookflare
 */
$post_ID = get_the_ID();
if ( themesflat_meta('time_event',$post_ID) ) {
	$time = strtotime(themesflat_meta('time_event',$post_ID));
	$date_event =  (int)date('Ymd',$time);
	$date_current =  (int)date('Ymd');
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-post blog-single post-single' ); ?>>
    <div class="content-page-wrap ">
        <div class="event-detail">
            <div class="img-single">
                <?php the_post_thumbnail('themesflat-blog', array('class'=>'responsive transition-img','alt' => esc_attr ( get_the_title() )) ); ?>
            </div>
            <div class="content">
                <div class="heading border-bt">
                    <h6 class="title"><?php the_title(); ?></h6>
                    <p class="description"><?php echo get_the_excerpt(); ?></p>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
									themesflat_teacher_event($tflat_teacher['teacher'],10);?>
                    </div>
                    <div class="col-md-6">
                        <div class="wrap-btn popup-get-ticket flat-text-right">
                        	<?php if ( themesflat_meta('time_event',$post_ID) ) {
    								if($date_event > $date_current){?>
    									 <a href="#popup-ticket" data-effect="mfp-zoom-in" class="flat-button btn-get-ticket"><?php esc_html_e('GET TICKET','bookflare');?></a>
    								<?php }else{
    									esc_html_e('The event is over','bookflare');
    								}
    							}
    		 				?>
                        </div>
                    </div>    
                </div>
            </div>
        </div> <!-- /.event-detail -->
        <div id="popup-ticket" class="white-popup mfp-with-anim mfp-hide">
        <?php if($date_event > $date_current ){ 
                if(function_exists( 'WPCF7' )){
                    $id_ct_tk = themesflat_meta('id_ticket')? themesflat_meta('id_ticket'):385;?>
                        <?php echo do_shortcode('[contact-form-7 id="'.$id_ct_tk.'" ]'); ?>
                <?php }else {esc_html_e('Please install plugin Contact Form 7', 'bookflare')  ;}
            } else { esc_html_e('The event is over', 'bookflare') ;}
         ?>
          </div>
        <div class="flat-tabs flat-tabs-single-event bg-fff border-ra4 border-f-e6f3ff">
            <ul class="tab-title style1 clearfix border-bt-e6f3ff"> 
                <li class="item-title  overview">
                    <span class="inner"><?php esc_html_e('OVERVIEW','bookflare');?></span>
                </li>
                <?php if (get_field('event_participants') != ''): ?>
                <li class="item-title event">
                    <span class="inner"><?php esc_html_e('EVENT PARTICIPANTS','bookflare');?></span>
                </li>
                <?php endif ?>
                <?php  
                $location = get_field('map_flat');
                        if( !empty($location) ): ?>
                    <li class="item-title map">
                        <span class="inner"><?php esc_html_e('MAP','bookflare');?></span>
                    </li>
                <?php endif; ?> 
            </ul>
            <div class="tab-content-wrap">
                <div class="tab-content">
                	<div class="container">
                		<div class="item-content">
                			<?php the_content(); ?>
                            <div class="text-wrap">
                                 <div class="wrap-btn">
                                    <?php $replace_str = str_replace(' ','+', get_the_excerpt()); 
                                        $replace_title = str_replace(' ','+', get_the_title());
                                     ?>
                                    <a target="_blank" href="https://www.google.com/calendar/event?action=TEMPLATE&text=<?php echo esc_attr($replace_title); ?>&dates=<?php echo esc_attr(date('Ymd',strtotime(themesflat_meta('time_event'))).'/'.date('Ymd',strtotime(themesflat_meta('time_event')))); ?>&details=<?php echo wp_strip_all_tags( esc_html($replace_str) ); ?>&location=<?php echo esc_attr(themesflat_meta('location_map')); ?>&trp=false&sprop=website:<?php echo get_the_permalink( ); ?>" class="flat-button btn-google border-ra4"><?php esc_html_e('+ GOOGLE CALENDAR','bookflare');?></a>
                                </div>
                            </div>
                        </div>
                	</div>
                </div>
                <?php if (get_field('event_participants') != ''): ?>
                    <div class="tab-content">
                        <div class="item-content">
                            <?php the_field('event_participants'); ?>
                        </div>
                    </div>
                <?php endif ?>
                <?php if(function_exists( 'themesflat_custom_shortcodes_class' )){ ?>
                    <div class="tab-content">
                        <div class="item-content">
                          <?php 
                            $location = get_field('map_flat');
                            if( !empty($location) ):
                            ?>
                            <div class="acf-map">
                                <div class="marker" data-lat="<?php echo esc_attr($location['lat']); ?>" data-lng="<?php echo esc_attr($location['lng']); ?>"></div>
                            </div>
                            <?php endif; ?> 
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div> <!-- /.flat-tabs -->
    </div> <!-- /.content-page-wrap -->
</article><!-- #post-## -->
