<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
if ( post_password_required() ) {
	return;
}
$link_profile = '';
if( is_user_logged_in()){
	if ( class_exists( 'LearnPress' )) {
		if ( flat_is_new_learnpress( '3.0' ) ) {
			$link_profile = esc_url( learn_press_user_profile_link() );
		} else {
			$link_profile = esc_url( apply_filters( 'learn_press_instructor_profile_link', '#',get_current_user_id(), '' ) );
		}
	}else {
		$link_profile = admin_url( 'profile.php' );
	}
}
?>
<div id="comments" class="flat-comments">
	<?php // You can start editing here -- including this comment! ?>
	<?php if ( have_comments() ) : ?>
		<fieldset class="comments-title">
			<h3 class="title"><?php comments_number( esc_html__('Comment','bookflare'), esc_html__('Comment ','bookflare'), esc_html__('Comments','bookflare')); ?></h3>
		</fieldset>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-above" class="comment-navigation col-xs-12 col-sm-12 col-md-12 col-lg-12">
			<h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'bookflare' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'bookflare' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'bookflare' ) ); ?></div>
		</nav><!-- #comment-nav-above -->
		<?php endif; // check for comment navigation ?>
		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'max_depth'		=> 5,
					'style'      => 'ol',
					'short_ping' => true,
					'avatar_size' => 70,
					'callback' => 'themesflat_custom_comment',
					'reply_text' => esc_html__( 'reply ', 'bookflare' ),
				) );
			?>
		</ol><!-- .comment-list -->
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-below" class="comment-navigation">
			<h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'bookflare' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'bookflare' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'bookflare' ) ); ?></div>
		</nav><!-- #comment-nav-below -->
		<?php endif; // check for comment navigation ?>
	<?php endif; // have_comments() ?>
	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'bookflare' ); ?></p>
	<?php endif; ?>
	<?php
		$commenter = wp_get_current_commenter();
		$fields =  array(
			'author' =>
				'<div class="wrap-input-all clearfix">
					<div class="wrap-input one-of-two pd-right-15">
				<p class="comment-form-author"><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" required aria-required="true" placeholder="' . esc_attr__('Name *', 'bookflare') . '" /></p>
					</div>',
			'email' =>
				'<div class="wrap-input one-of-two pd-left-15">
				<p class="comment-form-email"><input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" required aria-required="true" placeholder="' . esc_attr__('Email *', 'bookflare') . '"  /></p>
					</div>
				</div>',
		);
		$args = array(
			'id_form'           => 'commentform',
			'id_submit'         => 'submit',
			'class_submit'      => 'flat-button btn-send submit',
			'name_submit'       => 'submit',
			'title_reply_before'=> '<h3 class="title">',
			'title_reply'       => esc_html__( 'Leave a reply', 'bookflare' ),
			'title_reply_to'    => esc_html__( 'Leave a comment %s', 'bookflare' ),
			'cancel_reply_link' => esc_html__( '', 'bookflare' ),
			'label_submit'      => esc_html__( 'Comment', 'bookflare' ),
			'submit_button'		=>'<button type="submit" id="submit" class="flat-button btn-send submit">'.esc_html__( 'SEND COMMENT', 'bookflare' ).'</button>',
			'format'            => 'xhtml',
			'comment_field' =>  '<p class="comment-form-comment wrap-textarea"><textarea id="comment" name="comment" cols="60" rows="6" aria-required="true" placeholder="'. esc_attr__('Comment','bookflare').'">' . '</textarea></p>',
			'must_log_in' => '<p class="must-log-in">' .
			  sprintf(''.esc_html__('You must be ','bookflare').'<a href="%s">'.esc_html__('logged in ','bookflare').'</a>'.esc_html__(' to post a comment.','bookflare').'',
				wp_login_url( apply_filters( 'the_permalink', get_permalink() ) )
			  ) . '</p>',
			'logged_in_as' => '<p class="logged-in-as">' .
			  sprintf(''.esc_html__('Logged in as ','bookflare').'<a href="%1$s">%2$s</a>. <a href="%3$s" title="'.esc_attr__('Log out of this account','bookflare').'">'.esc_html__('Log out?','bookflare').'</a>',
				$link_profile,
				$user_identity,
				wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) )
			  ) . '</p>',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'fields' => apply_filters( 'comment_form_default_fields', $fields ),
		  );
		comment_form($args);
	?>
</div><!-- #comments -->