<?php
class Themesflat_Categories_Courses extends WP_Widget {
    /**
     * Holds widget settings defaults, populated in constructor.
     *
     * @var array
     */
    protected $defaults;
    /**
     * Constructor
     *
     * @return Themesflat_Categories_Courses
     */
    function __construct() {
        $this->defaults = array(
            'title'         => 'Categories Courses',
            'cate_ex'       =>'',
            'cat_parent_child'=>'',
            'cate_clss'        =>''
        );
        parent::__construct(
            'widget_categories_courses',
            esc_html__( 'Themesflat - Categories Courses', 'bookflare' ),
            array(
                'classname'   => 'widget_categories_courses',
                'description' => esc_html__( 'Categories.', 'bookflare' )
            )
        );
    }
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        extract( $instance );
        extract( $args ); 
        echo sprintf($before_widget);
        $check_id_cat = array();
         if(empty($cat_parent_child)){
           $terms = get_terms( array( 
                'taxonomy'      => 'course_category',
                'hide_empty'    =>false,
                'child_of'      => array(),
                'exclude'       => explode(",", $cate_ex),
            ) );
         }else{
             $terms = get_terms( array( 
                'taxonomy'      => 'course_category',
                'hide_empty'    =>false,
                'child_of'      => $cat_parent_child[0],
                'exclude'       => explode(",", $cate_ex),
            ) );
         }
        ?>
         <div class="widget-categories border-f-e6f3ff <?php echo esc_attr($cate_clss); ?>">
            <?php if ( !empty($title) ) echo  '<h6 class="title-widget">'.$title.'</h6>';?>
            <div class="content">
                <ul>
                    <?php 
                    foreach ( $terms as $term ) { ?>
                        <li><a href="<?php echo get_term_link( $term ); ?>"><?php echo esc_attr($term->name) ?> <span>(<?php echo esc_attr($term->count) ?>)</span></a>
                        </li>
                    <?php  }  ?>
                </ul>
            </div>
        </div> <!-- /.widget-categories --> 
        <?php echo sprintf($after_widget); 
    }
    /**
     * Update widget
     */
    function update( $new_instance, $old_instance ) {
        $instance                   = $old_instance;
        $instance['title']          = strip_tags( $new_instance['title'] );
        $instance['cat_parent_child']           = array_filter( $new_instance['cat_parent_child'] );   
        $instance['cate_ex'] = esc_attr( $new_instance['cate_ex'] );
         $instance['cate_clss'] = esc_attr( $new_instance['cate_clss'] );
        
        return $instance;
    }
    /**
     * Widget setting
     */
    function form( $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        if (empty($instance['cat_parent_child'])) {                    
            $instance['cat_parent_child'] = array("1");
        }
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
        </p>
        <p>
            <?php $terms = get_terms( array( 
                    'taxonomy' => 'course_category',
                    'hide_empty'=>false,
                    'parent' => 0,
                ) );
            ?>
            <select id="<?php echo esc_attr( $this->get_field_id( 'cat_parent_child' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cat_parent_child' ) ); ?>[]" class="widefat">
                <option value="0" <?php selected( empty( $instance['cat_parent_child'] ) ); ?>><?php esc_html_e( 'All', 'bookflare' ); ?></option>
                <?php foreach ( $terms as $term ) {
                     printf('<option value="%1$s" %4$s>%2$s (%3$s)</option>', esc_attr($term->term_id), esc_attr($term->name), esc_attr($term->count), (in_array($term->term_id, $instance['cat_parent_child'] )) ? 'selected="selected"' : '');
                 } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'cate_ex' ) ); ?>"><?php esc_html_e( 'Category exclude:(140,123,...)', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'cate_ex' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cate_ex' ) ); ?>" type="text" value="<?php echo esc_attr($instance['cate_ex']) ; ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'cate_clss' ) ); ?>"><?php esc_html_e( 'Add class:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'cate_clss' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cate_clss' ) ); ?>" type="text" value="<?php echo esc_attr($instance['cate_clss']) ; ?>">
        </p>
    <?php
    }
}
add_action( 'widgets_init', 'themesflat_register_categories_courses' );
/**
 * Register widget
 *
 * @return void
 * @since 1.0
 */
function themesflat_register_categories_courses() {
    register_widget( 'Themesflat_Categories_Courses' );
}