<?php
class Themesflat_book_event extends WP_Widget {
    /**
     * Holds widget settings defaults, populated in constructor.
     *
     * @var array
     */
    protected $defaults;
    /**
     * Constructor
     *
     * @return Themesflat_book_event
     */
    function __construct() {
        $this->defaults = array(
            'title'         => ''
        );
        parent::__construct(
            'widget_book_event',
            esc_html__( 'Themesflat - Book event', 'bookflare' ),
            array(
                'classname'   => 'widget_book_event',
                'description' => esc_html__( 'Book event.', 'bookflare' )
            )
        );
    }
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
        global $post;
        $instance = wp_parse_args( $instance, $this->defaults );
        $title = empty( $instance['title'] ) ? 'Event Details' : $instance['title'];
        $desc = empty( $instance['desc'] ) ? '' : $instance['desc'];
        $event_show = $instance['event_show'];
        extract( $instance );
        extract( $args );
        if(is_singular('event')){
            $post_ID = get_the_ID();
        }else{
            $post_ID = $event_show;
        }
        if ( themesflat_meta('time_event',$post_ID) ) {
                $time = strtotime(themesflat_meta('time_event',$post_ID));
                $date_event =  (int)date('Ymd',$time);
                $date_current =  (int)date('Ymd');
                $date_day = date('d',$time);
                $date_month = date('m',$time);
                $date_year = date('Y',$time);
                $date_hour = date('H',$time);
                $date_minutes = date('i',$time);
                $date_second = date('s',$time);
            }
        echo sprintf($before_widget);?>
        <div class="sidebar-right">
            <div class="widget-counter">
                <div class="flat-counter clearfix flat-text-center count-time-single" data-day_sg="<?php echo esc_attr($date_day); ?>" data-month_sg="<?php echo esc_attr($date_month); ?>" data-year_sg="<?php echo esc_attr($date_year); ?>" data-hour_sg="<?php echo esc_attr($date_hour); ?>" data-minute_sg="<?php echo esc_attr($date_minutes); ?>" data-second_sg="<?php echo esc_attr($date_second); ?>">
                    <div class="counter one-of-four days_sg">
                        <div class=" border-f-e6f3ff border-ra4">
                            <div class="numb_sg"><?php echo esc_attr($date_day); ?></div>
                            <div class="text"><?php esc_html_e('DAYS','bookflare');?></div>
                        </div>
                    </div>
                    <div class="counter one-of-four hours_sg ">
                        <div class=" border-f-e6f3ff border-ra4">
                            <div class="numb_sg"><?php echo esc_attr($date_hour); ?></div>
                            <div class="text"><?php esc_html_e('HOURS','bookflare');?></div>
                        </div>
                    </div>
                    <div class="counter one-of-four minutes_sg">
                        <div class=" border-f-e6f3ff border-ra4">
                            <div class="numb_sg"><?php echo esc_attr($date_minutes); ?></div>
                            <div class="text"><?php esc_html_e('MINUTES','bookflare');?></div>
                        </div>
                    </div>
                    <div class="counter one-of-four seconds_sg ">
                        <div class=" border-f-e6f3ff border-ra4">
                            <div class="numb_sg"><?php echo esc_attr($date_second); ?></div>
                            <div class="text"><?php esc_html_e('SECONDS','bookflare');?></div>
                        </div>
                    </div>
                </div>
            </div> <!-- /.widget-counter -->
            <div class="widget-event-detail border-f-e6f3ff">
                <h4 class="widget-title flat-text-center"><?php echo esc_html($title);?></h4>
                <p class="description flat-text-center"> <?php echo wp_kses_post( $desc );?></p>
                <ul class="list-detail">
                    <li class="slot clearfix">
                        <span class="title"><?php esc_html_e('TOTAL SLOT','bookflare');?></span>
                        <span class="value"><?php echo themesflat_meta('total_slot') ? esc_attr(themesflat_meta('total_slot')) : '--/--'; ?></span>
                    </li>
                    <li class="cost clearfix">
                        <span class="title"><?php esc_html_e('COST','bookflare');?></span>
                        <span class="value"><?php echo themesflat_meta('cost_event') ? esc_attr(themesflat_meta('cost_event')) : '--/--' ; ?></span>
                    </li>
                    <li class="start-time clearfix">
                        <span class="title"><?php esc_html_e('START TIME','bookflare');?></span>
                        <span class="value"><?php echo themesflat_meta('start_time') ? esc_attr(themesflat_meta('start_time')) : '--/--' ; ?></span>
                    </li>
                    <li class="end-time clearfix">
                        <span class="title"><?php esc_html_e('END TIME','bookflare');?></span>
                        <span class="value"><?php echo themesflat_meta('end_time') ? esc_attr(themesflat_meta('end_time')) : '--/--' ; ?></span>
                    </li>
                    <li class="location clearfix">
                        <span class="title"><?php esc_html_e('LOCATION','bookflare');?></span>
                        <span class="value"><?php echo themesflat_meta('location_map') ? esc_attr(themesflat_meta('location_map')) : '--/--' ; ?></span>
                    </li>                             
                </ul>
                <div class="wrap-btn flat-text-center popup-get-ticket">
                    <?php if ( themesflat_meta('time_event',$post_ID) ) {
                            if($date_event > $date_current){?>
                                 <a href="#popup-book-ticket" data-effect="mfp-zoom-in" class="flat-button btn-book-now border-ra4"><?php esc_html_e('BOOK NOW!','bookflare');?></a>
                            <?php }else{
                                esc_html_e('The event is over','bookflare');
                            }
                        }
                    ?>
                </div> 
                   
            </div>
        </div> <!-- /.sidebar-right -->
        <div id="popup-book-ticket" class="white-popup mfp-with-anim mfp-hide">
            <?php if($date_event > $date_current ){ 
                    if(function_exists( 'WPCF7' )){
                        $id_ct_tk = themesflat_meta('id_ticket')? themesflat_meta('id_ticket'):385;?>
                            <?php echo do_shortcode('[contact-form-7 id="'.$id_ct_tk.'" ]'); ?>
                    <?php }else {esc_html_e('Please install plugin Contact Form 7', 'bookflare')  ;}
                } else { esc_html_e('The event is over', 'bookflare') ;}
             ?>
        </div>
        <?php echo sprintf($after_widget) ;
    }
    /**
     * Update widget
     */
    function update( $new_instance, $old_instance ) {
        $instance                   = $old_instance;
        $instance['title'] = $new_instance['title'] ? $new_instance['title'] : 'Event Details';
        $instance['desc'] = $new_instance['desc'];
        $instance['event_show'] = $new_instance['event_show'];
        return $instance;
    }
    /**
     * Widget setting
     */
    function form( $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        $title = $instance['title'];
        $desc = $instance['desc'];
        if (empty($instance['event_show'])) {                    
            $instance['event_show'] = array("1");
        }
        $query_args = array(
            'post_type' => 'event',
            'posts_per_page' => -1,
            'orderby' => 'date',
            'order' => 'DESC'
        );
        $Query = new WP_Query( $query_args );
        ?>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'bookflare' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></label></p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id('desc')); ?>">
            <?php esc_html_e('Description','bookflare');?>:
            <textarea class="widefat" rows="4" cols="20" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo wp_kses_post($instance['desc']); ?></textarea>
        </label>
        </p>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'event_show' ) ); ?>"><?php esc_html_e( 'Choose one event want show', 'bookflare' ); ?>:</label>
            <select id="<?php echo esc_attr( $this->get_field_id( 'event_show' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'event_show' ) ); ?>" class="widefat" <?php selected( empty( $instance['event_show'] ) ); ?>>
                <?php if ( $Query->have_posts() ) : ?>
                     <?php while ( $Query->have_posts() ) : $Query->the_post(); ?>
                <option value="<?php echo get_the_id(); ?>" <?php echo (get_the_id() == $instance['event_show'] ) ? 'selected="selected"' : '' ;?>><?php the_title(); ?></option>
            <?php endwhile;
            endif; ?>
            </select>
        </p>
    <?php

    }
}
add_action( 'widgets_init', 'themesflat_register_book_event' );
/**
 * Register widget
 *
 * @return void
 * @since 1.0
 */
function themesflat_register_book_event() {
    register_widget( 'Themesflat_book_event' );
}
						