<?php
/**
 * Teacher custom post type.
 *
 * @package Bookflare
 * @since   1.0.0
 */
// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
class Coacha_Fun_Teacher {
	/**
	 * Construct function.
	 *
	 * @return  void
	 */
	function __construct() {
		add_action( 'init', array( __CLASS__, 'teacher_init' ) );
	}
	/**
	 * Register a teacher post type.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_post_type
	 */
	public static function teacher_init() {
		register_post_type( 'teacher',
			array(
				'public'             => true,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'query_var'          => true,
				'rewrite'            => array( 'slug' => 'teacher' ),
				'capability_type'    => 'post',
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => 5,
				'menu_icon'          => 'dashicons-businessman',
				'supports'           => array( 'title', 'editor', 'thumbnail','excerpt' ),
				'labels'             => array(
					'name'               => _x( 'Teacher', 'bookflare' ),
					'singular_name'      => _x( 'Teacher', 'bookflare' ),
					'menu_name'          => _x( 'Teacher', 'bookflare' ),
					'name_admin_bar'     => _x( 'Teacher', 'bookflare' ),
					'add_new'            => _x( 'Add New', 'bookflare' ),
					'add_new_item'       => __( 'Add New Teacher', 'bookflare' ),
					'new_item'           => __( 'New Teacher', 'bookflare' ),
					'edit_item'          => __( 'Edit Teacher', 'bookflare' ),
					'view_item'          => __( 'View Teacher', 'bookflare' ),
					'all_items'          => __( 'All Teachers', 'bookflare' ),
					'search_items'       => __( 'Search Teachers', 'bookflare' ),
					'parent_item_colon'  => __( 'Parent Teachers:', 'bookflare' ),
					'not_found'          => __( 'No teachers found.', 'bookflare' ),
					'not_found_in_trash' => __( 'No teachers found in Trash.', 'bookflare' )
				),
			)
		);
		// Register teacher category
		register_taxonomy( 'teacher_cat',
			array( 'teacher' ),
			array(
				'hierarchical'      => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'teacher_cat' ),
				'labels'            => array(
					'name'              => _x( 'Categories', 'bookflare' ),
					'singular_name'     => _x( 'Category', 'bookflare' ),
					'search_items'      => __( 'Search Categories', 'bookflare' ),
					'all_items'         => __( 'All Categories', 'bookflare' ),
					'parent_item'       => __( 'Parent Category', 'bookflare' ),
					'parent_item_colon' => __( 'Parent Category:', 'bookflare' ),
					'edit_item'         => __( 'Edit Category', 'bookflare' ),
					'update_item'       => __( 'Update Category', 'bookflare' ),
					'add_new_item'      => __( 'Add New Category', 'bookflare' ),
					'new_item_name'     => __( 'New Category Name', 'bookflare' ),
					'menu_name'         => __( 'Categories', 'bookflare' ),
				),
			)
		);
	}
}
$teacher = new Coacha_Fun_Teacher;