<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_Testimonial_Slider extends WPBakeryShortCodesContainer {
    }
}

add_filter( 'themesflat/shortcode/testimonial_class', 'themesflat_custom_shortcodes_class', 10, 2 );
add_filter( 'themesflat/shortcode/testimonial_slider_class', 'themesflat_custom_shortcodes_class', 10, 2 );
add_action( 'vc_before_init', 'themesflat_testimonial_shortcode_params' );

function themesflat_testimonial_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    =>esc_html__( 'Themesflat: Testimonial Slider', 'bookflare' ),
		'base'                    => 'testimonial_slider',
		'as_parent'               => array( 'only' => 'testimonial' ), 
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'params'                  => array(			
			array(
				'type' => 'textfield',
				'heading' =>esc_html__( 'Margin', 'bookflare' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' =>esc_html__( 'Margin item for slide', 'bookflare' )
			),
			array(
				'type' => 'textfield',
				'heading' =>esc_html__( 'Slides per view', 'bookflare' ),
				'param_name' => 'slides_per_view',
				'value' => '2',
				'description' =>esc_html__( 'Set numbers of slides you want to display', 'bookflare' )
			),
			array(
				'type' => 'checkbox',
				'heading' =>esc_html__( 'Slider autoplay', 'bookflare' ),
				'param_name' => 'autoplay',
				'description' =>esc_html__( 'Disable autoplay mode.', 'bookflare' ),
				'value' => array(esc_html__( 'Yes, please', 'bookflare' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' =>esc_html__( 'Hide pagination control', 'bookflare' ),
				'param_name' => 'hide_control',
				'description' =>esc_html__( 'If YES pagination control will be removed.', 'bookflare' ),
				'value' => array(esc_html__( 'Yes, please', 'bookflare' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' =>esc_html__( 'Hide prev/next buttons', 'bookflare' ),
				'param_name' => 'hide_buttons',
				'description' =>esc_html__( 'If "YES" prev/next control will be removed.', 'bookflare' ),
				'value' => array(esc_html__( 'Yes, please', 'bookflare' ) => 'yes' )
			),			
			array(
				'type' => 'textfield',
				'heading' =>esc_html__( 'Extra class name', 'bookflare' ),
				'param_name' => 'class',
				'description' =>esc_html__( 'Add class for your design', 'bookflare' )
			),
			array(
				'type' => 'dropdown',
				'class' => '',
				'heading' => __('Template', 'bookflare'),
				'param_name' => 'styles',
				'value' => array(
					__('Style Default','bookflare') => '',
					__('Style one item','bookflare') => 'one_item'
				),
				'description' => __('Select style in this element.', 'bookflare')
			),
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the single testimonial item
	 */
	vc_map( array(
		'base'        => 'testimonial',
		'name'        =>esc_html__( 'Themesflat: Testimonial', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'category'    =>esc_html__( 'Themesflat', 'bookflare' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     =>esc_html__( 'Name', 'bookflare' ),
				'param_name'  => 'name'
			),
			array (
                'type' => 'colorpicker',
                'heading' => __( 'Color Title', 'bookflare' ),
                'param_name' => 'color',
                'value' => '#192836',
                'description' => __( 'Color', 'bookflare' ),
            ),
            array (
                'type' => 'colorpicker',
                'heading' => __( 'Color Hover Title', 'bookflare' ),
                'param_name' => 'color_hv',
                'value' => '#f3728b',
                'description' => __( 'Color', 'bookflare' ),
            ),
			array(
				'type'       => 'attach_image',
				'heading'    =>esc_html__( 'Image', 'bookflare' ),
				'param_name' => 'image'
			),

			array(
				'type'             => 'textfield',
				'heading'          =>esc_html__( 'Position', 'bookflare' ),
				'param_name'       => 'position',
			),

			array(
				'type'             => 'textfield',
				'heading'          =>esc_html__( 'Link', 'bookflare' ),
				'param_name'       => 'link'
			),
			array(
				'type'       => 'textarea',
				'heading'    =>esc_html__( 'Content', 'bookflare' ),
				'param_name' => 'content'
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Facebook URL', 'bookflare' ),
				'param_name' => 'facebook'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Twitter URL', 'bookflare' ),
				'param_name' => 'twitter'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Google URL', 'bookflare' ),
				'param_name' => 'google'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'LikeIn URL', 'bookflare' ),
				'param_name' => 'likedin'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Instagram URL', 'bookflare' ),
				'param_name' => 'instagram'
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Skype URL', 'bookflare' ),
				'param_name' => 'skype'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Github URL', 'bookflare' ),
				'param_name' => 'github'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Vimeo URL', 'bookflare' ),
				'param_name' => 'vimeo'
			),
			array(
				'type'       => 'textfield',
				'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		)
	) );
}

add_shortcode( 'testimonial', 'themesflat_shortcode_testimonial' );
add_shortcode( 'testimonial_slider', 'themesflat_shortcode_testimonial_slider' );

/**
 * Testimonial shortcode handle
 * 
 * @param   string  $atts  Shortcode attributes
 * @return  void
 */
function themesflat_shortcode_testimonial( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'testimonial', $atts );
	$testimonial_image = '';
	$class = apply_filters( 'themesflat/shortcode/testimonial_class', array( 'testimonial', $atts['class']), $atts );
	$social_links = '';

	if ( ! empty( $atts['facebook'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="Facebook" class="facebook"><i class="fab fa fa-facebook"></i></a></li>', esc_url( $atts['facebook'] ) );

	if ( ! empty( $atts['twitter'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="Twitter" class="twitter"><i class="fab fa fa-twitter"></i></a></li>', esc_url( $atts['twitter'] ) );

	if ( ! empty( $atts['vimeo'] ) )
		$social_links.= sprintf( '<li><a href="%s" data-title="vimeo" class="vimeo"><i class="fab fa fa-vimeo"></i></a></li>', esc_url( $atts['vimeo'] ) );

	if ( ! empty( $atts['google'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="google" class="google"><i class="fab fa fa-google-plus"></i></a></li>', esc_url( $atts['google'] ) );

	if ( ! empty( $atts['likedin'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="likedin" class="likedin"><i class="fab fa fa-linkedin"></i></a></li>', esc_url( $atts['likedin'] ) );

	if ( ! empty( $atts['instagram'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="Instagram" class="instagram"><i class="fab fa fa-instagram"></i></a></li>', esc_url( $atts['instagram'] ) );

	if ( ! empty( $atts['github'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="Github" class="Github"><i class="fab fa fa-github"></i></a></li>', esc_url( $atts['github'] ) );

	if ( ! empty( $atts['skype'] ) )
		$social_links.= sprintf( '<li> <a href="%s" data-title="skype" class="skype"><i class="fab fa fa-skype"></i></a></li>', esc_url( $atts['skype'] ) );

	// $box_social_links = '';
	if ( ! empty( $social_links ) )
		$social_links = sprintf( '%s',$social_links);

	if ( ! empty( $atts['image'] ) ) {
		if ( is_numeric( $atts['image'] ) ) {
			$image_src = wp_get_attachment_image_src( $atts['image'], 'full' );
			$atts['image'] = array_shift( $image_src );
		}
		$class[] = 'has-image';
		$testimonial_image = sprintf( '<img src="%s" alt="%s">
		', esc_attr( $atts['image'] ), esc_attr( $atts['name'] ) );
	}
	return sprintf( '
		<div class="testimonial clearfix %1$s">
            <div class="wrap-avata-socails flat-text-center">
                <div class="avata">
                    <a href="%5$s">%4$s</a>
                </div>
                <div class="socails">
                    <ul class="list">
                    	%7$s
                    </ul>
                </div>
            </div>
            <div class="wrap-content">
                <div class="info">
                    <h4 class="name" data-color_hover="%9$s"><a href="%5$s" style="color:%8$s">%3$s</a></h4>
                    <p class="position">%6$s</p>
                </div>
                <blockquote>
                    %2$s
                </blockquote>
            </div>
        </div>',
	esc_attr( implode( ' ', $class ) ),
	wp_kses_post( $content ),	
	esc_html( $atts['name'] ),
	wp_kses_post( $testimonial_image ),
	esc_url( $atts['link'] ),
	esc_html( $atts['position'] ),
	wp_kses_post($social_links),
	esc_attr($atts['color']),esc_attr($atts['color_hv']));
}

/**
 * This function will be use to handle testimonial slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function themesflat_shortcode_testimonial_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'testimonial_slider', $atts );
	$config = $atts;
	unset( $config['class'] );
	unset( $config['css'] );
	$class = apply_filters( 'themesflat/shortcode/testimonial_slider_class', array( 'testimonial-slider', $atts['class'],$atts['styles']), $atts );
	// Enqueue shortcode assets
	wp_enqueue_script( 'themesflat-carousel' );
	
	return sprintf( '
		<div class="%s" data-margin="%s" data-slides_per_view="%s" data-autoplay="%s" data-hide_control="%s" data-hide_buttons="%s">			
			%s				
		</div>
	', implode( ' ', $class ), esc_attr( $atts['margin'] ) , esc_attr( $atts['slides_per_view'] ), esc_attr( $atts['autoplay'] ), esc_attr( $atts['hide_control'] ), esc_attr( $atts['hide_buttons'] ),  do_shortcode( $content ) );
}

