<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_tabs extends WPBakeryShortCodesContainer {
    }
    class WPBakeryShortCode_tab extends WPBakeryShortCodesContainer {
    }
}

add_action( 'vc_before_init', 'themesflat_tab_shortcode_params' );

function themesflat_tab_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    =>esc_html__( 'Themesflat: Tabs', 'bookflare' ),
		'base'                    => 'tabs',
		'as_parent'               => array( 'only' => 'tab' ), 
		'content_element'         => true,
		'show_settings_on_create' => true,
		'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'params'                  => array(
			
			array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Choose Style For Tabs', 'bookflare' ),
					'param_name' => 'style_tabs',
					'value' => array(
						esc_html__( 'Style 1', 'bookflare' )   => 'style1',
						esc_html__( 'Style 2', 'bookflare' )   => 'style2'
						),
					'std '		 => 'style1'
				),
			array(
				'type'       => 'textfield',
				'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class'
			),
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			),
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the single testimonial item
	 */
	vc_map( array(
		'base'        => 'tab',
		'name'        =>esc_html__( 'Themesflat: Tab', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'category'    =>esc_html__( 'Themesflat', 'bookflare' ),
		'content_element'         => true,
		'show_settings_on_create' => true,
		"as_child" => array('only' => 'tabs'),
	    'as_parent'			=> array(''),
		'params'      => array(
			// Image Icon
			array(
	            'type' => 'attach_image',
	            'class' => '',
	            'heading' => __('Image Icon', 'bookflare'),
	            'param_name' => 'image',
	            'admin_label' => true,
	            'value' => '',
	            'description' => __('Select image icon in this element', 'bookflare')
	        ),
	        array(
				'type'             => 'textfield',
				'heading'          =>esc_html__( 'Rotate iconbox (Ex:30)', 'bookflare' ),
				'param_name'       => 'rotate_icon',
				'admin_label' => true,
				'std '		 => 0
			),
			// Title
			array(
				'type'             => 'textfield',
				'heading'          =>esc_html__( 'Title iconbox ', 'bookflare' ),
				'param_name'       => 'title',
				'admin_label' => true,
			),

			array(
				'type'       => 'textfield',
				'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		),
		'js_view' => 'VcColumnView'
	) );
}

add_shortcode( 'tab', 'themesflat_shortcode_tab' );
add_shortcode( 'tabs', 'themesflat_shortcode_tabs' );

/**
 * tab shortcode handle
 * 
 * @param   string  $atts  Shortcode attributes
 * @return  void
 */
function themesflat_shortcode_tab( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'tab', $atts );
	extract( $atts);
    return sprintf( '<div class="tab-content box-shadow ">
                <div class="item-content clearfix">%1$s</div>
			</div>',do_shortcode( $content ));
}

/**
 * This function will be use to handle tabs slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function themesflat_shortcode_tabs( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'tabs', $atts );
	extract($atts);
	$tab_titles = array();
	$tab_title_array = array();
	$tab_rotate = array();
	$tab_rotate_array = array();
	$tab_images = array();
	$tab_image_array = array();
	$number_title = preg_match_all('/title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE);
	$number_img = preg_match_all('/image="([^\"]+)"/i', $content, $matches2, PREG_OFFSET_CAPTURE);
	$number_rotate = preg_match_all('/rotate_icon="([^\"]+)"/i', $content, $matches3, PREG_OFFSET_CAPTURE);
   	if (isset($matches[0])) {
        	$tab_titles = $matches[0];
        }
    foreach($tab_titles as $tab) {
    	preg_match('/title="([^\"]+)"/i', $tab[0], $tab_matches, PREG_OFFSET_CAPTURE);
    	$tab_title_array[] = $tab_matches[1][0];
    }
    if (isset($matches2[0])) {
        	$tab_images = $matches2[0];
        }
    foreach($tab_images as $img) {
    	preg_match('/image="([^\"]+)"/i', $img[0], $img_matches, PREG_OFFSET_CAPTURE);
    	$tab_image_array[] = $img_matches[1][0];
    }
    if (isset($matches3[0])) {
        	$tab_rotate = $matches3[0];
        }
    foreach($tab_rotate as $rotate) {
    	preg_match('/rotate_icon="([^\"]+)"/i', $rotate[0], $rotate_matches, PREG_OFFSET_CAPTURE);
    	$tab_rotate_array[] = $rotate_matches[1][0];
    }
    ob_start();
    if($atts['style_tabs']=== 'style1'){?>
    	<div class="flat-tabs ft-services tab-has-icon <?php echo esc_attr($atts['class']); ?>">
			<ul class="tab-title clear-sub-columns style5">
				<?php for($i = 0 ; $i < $number_title;$i++){?>
			    	<li class="item-title col-md-3 col-sm-3 col-6">
			            <div class="iconbox style4 flat-text-center one">
			            	<?php if(!empty($tab_image_array[$i])){?>
				                <div class="iconbox-icon" style="transform: rotate(<?php echo esc_attr($tab_rotate_array[$i]); ?>deg);">
				                    <?php echo wp_get_attachment_image( $tab_image_array[$i], 'full'); ?>
				                </div>
				            <?php } ?>
			                <div class="iconbox-content">
			                    <h6 class="title"><?php if(!empty($tab_title_array[$i])){ echo esc_attr($tab_title_array[$i]);} ?></h6>
			                </div>
			            </div>
			        </li>
			        <?php
			    		}
					?>
					</ul>
			 <div class="tab-content-wrap">
			 		<?php echo do_shortcode( $content ); ?>
			</div>
		</div>
    <?php }else{?>
    	<div class="flat-tabs border-t-e6f3ff style2">
            <ul class="tab-title style2 clearfix border-bt-e6f3ff  flat-text-center">
            	<?php for($i = 0 ; $i < $number_title;$i++){?>
            		 <li class="item-title">
                        <span class="inner"><?php if(!empty($tab_title_array[$i])){ echo esc_attr($tab_title_array[$i]);} ?></span>
                    </li>
		        <?php
		    		}
				?>
            </ul>
            <div class="container">
            	<div class="tab-content-wrap">
					<?php echo do_shortcode( $content ); ?>
				</div>
			</div>
        </div>
    <?php $dkm = 0; } 
    $output = ob_get_clean();
    return $output;
}
