<?php
add_action('vc_before_init','themesflat_login_form_shortcode_params');
function themesflat_login_form_shortcode_params(){
	vc_map(
		array(
			'name' => __('Login Form', 'bookflare'),
			'base' => 'login_form',
			'category' => __('Themesflat', 'bookflare'),
			'icon' 		=> THEMESFLAT_ICON,
			'params' => array(
				array(
					'type' => 'textfield',
					'class' => '',
					'heading' => __('Link Redirect when login', 'bookflare'),
					'param_name' => 'redirect_login',
					'value' => '',
					'description' => __( '' )
				),
				array(
					'type' => 'textfield',
					'class' => '',
					'heading' => __('Link Redirect when register', 'bookflare'),
					'param_name' => 'redirect_registered',
					'value' => '',
					'description' => __( '' )
				),
				array(
					'type' => 'textfield',
					'class' => '',
					'heading' => __('Extra Class', 'bookflare'),
					'param_name' => 'el_class',
					'value' => '',
					'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'bookflare' )
				),
			)
		)
	);
}
add_shortcode('login_form','themesflat_login_form_func');
if( ! function_exists('themesflat_login_form_func')){
	function themesflat_login_form_func($atts, $content = null) {
		extract(shortcode_atts(array(
			'el_class' => '',
			'redirect_login'=>'',
			'redirect_registered'=>''
		), $atts));
		$class = array();
		ob_start();
		update_option( 'flat_login_page', get_the_ID() );
		if ( is_user_logged_in() ) {
			echo '<p class="message message-success">' . sprintf( wp_kses( __( 'You have logged in. <a href="%s">Sign Out</a>', 'bookflare' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( wp_logout_url( apply_filters( 'flat_default_logout_redirect', 'http://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"] ) ) ) ) . '</p>';
			return;
		}
		?>
		<?php if ( isset( $_GET['result'] ) || isset( $_GET['action'] ) ) : ?>
			<?php if ( isset( $_GET['result'] ) && $_GET['result'] == 'failed' ): ?>
				<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Incorrect username or password. Please try again!', 'bookflare' ) . '</p>'; ?>
			<?php endif; ?>
			<?php if ( ! empty( $_GET['action'] ) && $_GET['action'] == 'register' ) : ?>
				<?php if ( get_option( 'users_can_register' ) ) : ?>
					<?php if ( ! empty( $_GET['empty_username'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Please enter a username!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['empty_email'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Please type your e-mail address!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['username_exists'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'This username is already registered. Please choose another one!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['email_exists'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'This email is already registered. Please choose another one!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['invalid_email'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'The email address isn\'t correct. Please try again!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['invalid_username'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'The username is invalid. Please try again!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['passwords_not_matched'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Passwords must matched!', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<?php if ( ! empty( $_GET['gglcptch_error'] ) ) : ?>
						<?php echo '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'You have entered an incorrect reCAPTCHA value.', 'bookflare' ) . '</p>'; ?>
					<?php endif; ?>

					<div class="flat-login form-submit-register">
						<h2 class="title cs-title-form wp-caption-text"><?php esc_html_e( 'Register', 'bookflare' ); ?></h2>

						<form name="registerform" action="<?php echo esc_url( site_url( 'wp-login.php?action=register', 'login_post' ) ); ?>" method="post" novalidate="novalidate">
							<p>
								<input placeholder="<?php esc_attr_e( 'Username', 'bookflare' ); ?>" type="text" name="user_login" class="input required" />
							</p>

							<p>
								<input placeholder="<?php esc_attr_e( 'Email', 'bookflare' ); ?>" type="email" name="user_email" class="input required" />
							</p>

							<?php
							if ( is_multisite() && function_exists( 'gglcptch_login_display' ) ) {
								gglcptch_login_display();
							}

							do_action( 'register_form' );
							?>
							<p>
								<?php
									if ( empty( $redirect_registered ) ) {
										$redirect_registered = add_query_arg( 'result', 'registered', flat_get_login_page_url() );
									}
								?>
								<input type="hidden" name="redirect_to" value="<?php echo ! empty( $_REQUEST['redirect_to'] ) ? $_REQUEST['redirect_to'] : $redirect_registered; ?>" />
								<input type="hidden" name="modify_user_notification" value="1">
							</p>

							<?php do_action( 'signup_hidden_fields', 'create-another-site' ); ?>
							<p class="submit">
								<button type="submit" name="wp-submit" id="submit"  class="flat-button btn-send border-ra4"><?php esc_html_e( 'Sign up', 'bookflare' ); ?></button>
							</p>
						</form>
						<?php echo '<p class="link-bottom">' . esc_html__( 'Are you a member? ', 'bookflare' ) . ' <a href="' . esc_url( flat_get_login_page_url() ) . '">' . esc_html__( 'Login now', 'bookflare' ) . '</a></p>'; ?>
					</div>

					<?php return; ?>
				<?php else : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'Your site does not allow users registration.', 'bookflare' ) . '</p>'; ?>
					<?php return; ?>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ( isset( $_GET['action'] ) && $_GET['action'] == 'lostpassword' ) : ?>

				<?php if ( ! empty( $_GET['empty'] ) ) : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'Please enter a username or email!', 'bookflare' ) . '</p>'; ?>
				<?php endif; ?>
				<?php if ( ! empty( $_GET['user_not_exist'] ) ) : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'The user does not exist. Please try again!', 'bookflare' ) . '</p>'; ?>
				<?php endif; ?>

				<div class="flat-login form-submit-lost-password">
					<h2 class="title cs-title-form wp-caption-text"><?php esc_html_e( 'Get Your Password', 'bookflare' ); ?></h2>

					<form name="lostpasswordform" id="lostpasswordform" action="<?php echo esc_url( network_site_url( 'wp-login.php?action=lostpassword', 'login_post' ) ); ?>" method="post">
						<p class="description"><?php esc_html_e( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'bookflare' ); ?></p>

						<p>
							<input placeholder="<?php esc_attr_e( 'Username or email', 'bookflare' ); ?>" type="text" name="user_login" class="input required" />
							<input type="hidden" name="redirect_to" value="<?php echo esc_attr( add_query_arg( 'result', 'reset', flat_get_login_page_url() ) ); ?>" />
						</p>
						<p>
							<button type="submit" name="wp-submit" id="submit"  class="flat-button btn-send"><?php esc_html_e( 'Reset password', 'bookflare' ); ?></button>
						</p>
						<?php do_action( 'lostpassword_form' ); ?>
					</form>
				</div>
				<?php return; ?>
			<?php endif; ?>

			<?php if ( isset( $_GET['action'] ) && $_GET['action'] == 'rp' ) : ?>

				<?php if ( ! empty( $_GET['expired_key'] ) ) : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'The key is expired. Please try again!', 'bookflare' ) . '</p>'; ?>
				<?php endif; ?>
				<?php if ( ! empty( $_GET['invalid_key'] ) ) : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'The key is invalid. Please try again!', 'bookflare' ) . '</p>'; ?>
				<?php endif; ?>
				<?php if ( ! empty( $_GET['invalid_password'] ) ) : ?>
					<?php echo '<p class="message message-error">' . esc_html__( 'The password is invalid. Please try again!', 'bookflare' ) . '</p>'; ?>
				<?php endif; ?>

				<div class="flat-login form-submission-change-password">
					<h2 class="title cs-title-form wp-caption-text"><?php esc_html_e( 'Change Password', 'bookflare' ); ?></h2>

					<form name="resetpassform" id="resetpassform" action="<?php echo site_url( 'wp-login.php?action=resetpass' ); ?>" method="post" autocomplete="off">
						<input type="hidden" id="user_login" name="login" value="<?php echo isset( $_GET['login'] ) ? esc_attr( $_GET['login'] ) : ''; ?>" autocomplete="off" />
						<input type="hidden" name="key" value="<?php echo isset( $_GET['key'] ) ? esc_attr( $_GET['key'] ) : ''; ?>" />

						<p>
							<input placeholder="<?php esc_attr_e( 'New password', 'bookflare' ); ?>" type="text" name="password" id="password" class="input" />
						</p>

						<p class="resetpass-submit">
							<button type="submit" name="submit" id="resetpass-button"  class="flat-button btn-send"><?php esc_html_e( 'Reset password', 'bookflare' ); ?></button>
						</p>

						<p class="message message-success">
							<?php esc_html_e( 'Hint: The password should be at least twelve characters long. To make it stronger, use upper and lower case letters, numbers, and symbols like ! " ? $ % ^ &amp; ).', 'bookflare' ); ?>
						</p>

					</form>
				</div>
				<?php return; ?>
			<?php endif; ?>

			<?php if ( isset( $_GET['result'] ) && $_GET['result'] == 'registered' ) : ?>
				<?php echo '<p class="message message-success">' . sprintf( wp_kses( __( 'Registration is successful. Confirmation will be e-mailed before <a href="%s">login here</a>.', 'bookflare' ), array( 'a' => array( 'href' => array() ) ) ), flat_get_login_page_url() ) . '</p>'; ?>
				<?php return; ?>
			<?php endif; ?>

			<?php if ( isset( $_GET['result'] ) && $_GET['result'] == 'reset' ) : ?>
				<?php echo '<p class="message message-success">' . esc_html__( 'Check your email to get a link to create a new password.', 'bookflare' ) . '</p>'; ?>
				<?php return; ?>
			<?php endif; ?>

			<?php if ( isset( $_GET['result'] ) && $_GET['result'] == 'changed' ) : ?>
				<?php echo '<p class="message message-success">' . sprintf( wp_kses( __( 'Password changed. You can <a href="%s">login</a> now.', 'bookflare' ), array( 'a' => array( 'href' => array() ) ) ), flat_get_login_page_url() ) . '</p>'; ?>
				<?php return; ?>
			<?php endif; ?>

		<?php endif; ?>

		<div id="flat-form-login">
			<div class="flat-login-container">
				<div class="flat-login form-submit-login">
					<h2 class="title cs-title-form wp-caption-text"><?php esc_html_e( 'Login', 'bookflare' ); ?></h2>
					<?php
					if ( empty( $redirect_login ) ) {
							$redirect_login = home_url();
						}
					$redirect = ! empty( $_REQUEST['redirect_to'] ) ? esc_url( $_REQUEST['redirect_to'] ) : $redirect_login;

					$link_redirect = ! empty( $_REQUEST['redirect_to'] ) ? esc_url( $_REQUEST['redirect_to'] ) : '';
					$link_register = add_query_arg( 'redirect_to', urlencode( $link_redirect ), flat_get_register_url() );
					?>
					<form name="loginflatform" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post" novalidate>
						<p class="login-username">
							<input type="text" id="log" name="log" autocomplete="username" placeholder="<?php esc_html_e( 'Username or email', 'bookflare' ); ?>" required class="input required" size="20" />
						</p>
						<p class="login-password">
							<input type="password" autocomplete="current-password" id="pwd" name="pwd" placeholder="<?php esc_html_e( 'Password', 'bookflare' ); ?>" required class="input required" value="" size="20" />
						</p>
						<?php
						do_action( 'login_form' );
						?>
						<?php echo '<a class="lost-pass-link" href="' . flat_get_lost_password_url() . '" title="' . esc_attr__( 'Lost Password', 'bookflare' ) . '">' . esc_html__( 'Lost your password?', 'bookflare' ) . '</a>'; ?>
						<p class="forgetmenot login-remember">
							<label for="rememberMe"><input name="rememberme" type="checkbox" id="rememberMe" value="forever" /> <?php esc_html_e( 'Remember Me', 'bookflare' ); ?>
							</label></p>
						<p class="submit login-submit">
							<button type="submit" name="wp-submit" id="submit"  class="flat-button btn-send"><?php esc_html_e( 'Login', 'bookflare' ); ?></button>
							<input type="hidden" name="redirect_to" value="<?php echo esc_attr( $redirect ); ?>" />
							<input type="hidden" name="cookie" value="1" />
						</p>
					</form>
					<?php
					$registration_enabled = get_option( 'users_can_register' );
					if ( $registration_enabled ) {
						echo '<p class="link-bottom">' . esc_html__( 'Not a member yet? ', 'bookflare' ) . ' <a href="' . esc_attr( $link_register ) . '">' . esc_html__( 'Register now', 'bookflare' ) . '</a></p>';
					}
					?>
				</div>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}
}