<?php
if(strcasecmp($post_format,'video')==0){
	include 'entry_video.php';
}elseif(strcasecmp($post_format,'plan')==0){
	include 'plan.php';
}elseif(strcasecmp($post_format,'fitness')==0){
	include 'fitness.php';
}else{?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="themesflat-image">
		<?php if(has_post_thumbnail()){
			if($image_size){
				$image = wpb_getImageBySize( array( 'attach_id' => get_post_thumbnail_id(get_the_ID()), 'thumb_size' => $atts['image_size'] ) );
				$image = $image['thumbnail'];
				?>
				<a href="<?php the_permalink();?>"><?php echo wp_kses_post($image);?></a>
				<?php
			}else{
				the_post_thumbnail('themesflat-blog-shortcode', array('class'=>'img-responsive'));
			}
		}
	?>
	</div>
	<div class="themesflat_content">
		<?php if($show_title):?>
			<h3 class="title-blog"><a href="<?php the_permalink();?>" class="themesflat-title"><?php the_title(); ?></a></h3>
		<?php
		endif;
		if($show_info):
			echo themesflat_custom_info();
		endif;
		if($show_excerpt):?>
			<p><?php echo themesflat_custom_excerpt(intval($excerpt_length),$excerpt_more);?></p>
		<?php endif;
		if($read_more):?>
			<a href="<?php the_permalink();?>" class="read_more"><?php echo esc_attr($read_more_text);?></a>
		<?php endif;?>
		<div style="clear: both"></div>
	</div>
</article>
<?php }?>