<?php
add_action( 'admin_init', 'themesflat_page_options_init' );
function themesflat_page_options_init() {   
	new themesflat_meta_boxes(array( 
        'id'          => 'page-options',
        'label'       => esc_html__( 'Page Options', 'bookflare' ),
        'post_types'  => array('page','product'),
        'context'     => 'normal',
        'priority'    => 'default',       
        'sections' => array(
            'general'   => array( 'title' => esc_html__( 'General', 'bookflare' ) ),
            'page_title'   => array( 'title' => esc_html__( 'Page title and breadcrumb', 'bookflare' ) ),
            'header'    => array( 'title' => esc_html__( 'Header Options', 'bookflare' ) ),
            'blog'      => array( 'title' => esc_html__( 'Blog Post', 'bookflare' ) ),
            'footer'      => array( 'title' => esc_html__( 'Footer Option', 'bookflare' ) )
        ),
        'options' => themesflat_page_options_fields()
    ) );
    new themesflat_meta_boxes(array(
		'id' 	=> 'blog-options',
		'label'	=> esc_html__( 'Post settings', 'bookflare' ),
		'post_types'	=> 'post',
		'context'     => 'normal',
        'priority'    => 'default',
		'sections' => array(
            'blog'   => array( 'title' => esc_html__( 'Blog', 'bookflare' ) ),
			),
		'options' => themesflat_post_options_fields()
	));
	new themesflat_meta_boxes(array(
		'id'    => 'event-options',
		'label' => esc_html__('Time And Map Options','bookflare'),
		'post_types' => 'event',
		'context'    => 'normal',
		'priority'    => 'default',
		'sections' => array(
            'general'   => array( 'title' => esc_html__( 'General', 'bookflare' ) ),
            'page_title'   => array( 'title' => esc_html__( 'Page title and breadcrumb', 'bookflare' ) ),
			),
		'options' => themesflat_event_options_fields()
	));
	new themesflat_meta_boxes(array(
		'id'    => 'teacher-options',
		'label' => esc_html__('Teacher Options','bookflare'),
		'post_types' => 'teacher',
		'context'    => 'normal',
		'priority'    => 'default',
		'sections' => array(
            'general'   => array( 'title' => esc_html__( 'General', 'bookflare' ) ),
			),
		'options' => themesflat_teacher_options_fields()
	));
	new themesflat_meta_boxes(array(
		'id'    => 'course-options',
		'label' => esc_html__('Course Options','bookflare'),
		'post_types' => 'lp_course',
		'context'    => 'normal',
		'priority'    => 'default',
		'sections' => array(
            'general'   => array( 'title' => esc_html__( 'General', 'bookflare' ) ),
			),
		'options' => themesflat_course_options_fields()
	));
}
add_action( 'admin_enqueue_scripts', 'themesflat_admin_script_meta_box' );
/**
 * Enqueue script for handling actions with meta boxes
 *
 * @return void
 * @since 1.0
 */
function themesflat_admin_script_meta_box() {
	$screen = get_current_screen();	
	wp_enqueue_script( 'themesflat-meta-box', THEMESFLAT_LINK . 'js/admin/meta-boxes.js', array('customize-preview'), '1.1' );
}
function themesflat_load_custom_wp_admin_style() {
    wp_register_style( 'themesflat_wp_admin_css', THEMESFLAT_LINK .'js/admin/style.css', false, '1.0.0' );       
    wp_enqueue_style( 'themesflat_wp_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'themesflat_load_custom_wp_admin_style' );