<?php
/**
 * Event custom post type.
 *
 * @package Bookflare
 * @since   1.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

class Coacha_Fun_Event {
	/**
	 * Construct function.
	 *
	 * @return  void
	 */
	function __construct() {
		add_action( 'init', array( __CLASS__, 'event_init' ) );
	}

	/**
	 * Register a event post type.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_post_type
	 */
	public static function event_init() {
		register_post_type( 'event',
			array(
				'public'             => true,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'query_var'          => true,
				'rewrite'            => array( 'slug' => 'event' ),
				'capability_type'    => 'post',
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => 5,
				'menu_icon'          => 'dashicons-calendar-alt',
				'supports'           => array( 'title', 'editor', 'thumbnail','excerpt' ),
				'labels'             => array(
					'name'               => _x( 'Event', 'bookflare' ),
					'singular_name'      => _x( 'Event', 'bookflare' ),
					'menu_name'          => _x( 'Event', 'bookflare' ),
					'name_admin_bar'     => _x( 'Event', 'bookflare' ),
					'add_new'            => _x( 'Add New', 'bookflare' ),
					'add_new_item'       => __( 'Add New Event', 'bookflare' ),
					'new_item'           => __( 'New Event', 'bookflare' ),
					'edit_item'          => __( 'Edit Event', 'bookflare' ),
					'view_item'          => __( 'View Event', 'bookflare' ),
					'all_items'          => __( 'All Events', 'bookflare' ),
					'search_items'       => __( 'Search Events', 'bookflare' ),
					'parent_item_colon'  => __( 'Parent Events:', 'bookflare' ),
					'not_found'          => __( 'No events found.', 'bookflare' ),
					'not_found_in_trash' => __( 'No events found in Trash.', 'bookflare' )
				),
			)
		);

		// Register event category
		register_taxonomy( 'event_cat',
			array( 'event' ),
			array(
				'hierarchical'      => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'event_cat' ),
				'labels'            => array(
					'name'              => _x( 'Categories', 'bookflare' ),
					'singular_name'     => _x( 'Category', 'bookflare' ),
					'search_items'      => __( 'Search Categories', 'bookflare' ),
					'all_items'         => __( 'All Categories', 'bookflare' ),
					'parent_item'       => __( 'Parent Category', 'bookflare' ),
					'parent_item_colon' => __( 'Parent Category:', 'bookflare' ),
					'edit_item'         => __( 'Edit Category', 'bookflare' ),
					'update_item'       => __( 'Update Category', 'bookflare' ),
					'add_new_item'      => __( 'Add New Category', 'bookflare' ),
					'new_item_name'     => __( 'New Category Name', 'bookflare' ),
					'menu_name'         => __( 'Categories', 'bookflare' ),
				),
			)
		);
	}
}
$event = new Coacha_Fun_Event;