<?php
/**
 * Newsletter widget version 2.0: it'll replace the old version left for compatibility.
 */
class Themesflat_NewsletterWidget extends WP_Widget {
    function __construct() {
        parent::__construct(false, $name = 'Themesflat - Newsletter', array('description' => 'Newsletter widget to add subscription forms on sidebars'), array('width' => '350px'));
    }
    static function get_widget_form( array $instance=array() ) {
        $options_profile = get_option('newsletter_profile');
        $placeholder =( isset( $instance['placeholder'] ) ) ? $instance['placeholder'] : esc_html__('Email','bookflare');
        $email = is_email( $options_profile['email'] ) ? $options_profile['email'] : $placeholder;
        $form = '';
        $form .= '<form action="' . home_url('/') . '?na=s" onsubmit="return newsletter_check(this)" method="post">';
        // Referrer
        $form .= '<input type="hidden" name="nr" value="widget"/>';
        if ($options_profile['name_status'] == 2)
            $form .= '<p><input class="newsletter-firstname" placeholder="'. esc_attr( $placeholder ) .'" type="text" name="nn" value="' . esc_attr($options_profile['name']) . '" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/></p>';
        if ($options_profile['surname_status'] == 2)
            $form .= '<p><input class="newsletter-lastname" placeholder="'. esc_attr( $placeholder ) .'" type="text" name="ns" value="' . esc_attr($options_profile['surname']) . '" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/></p>';
        $form .= '<input type="email" name="ne"  placeholder="'. esc_attr( $placeholder ) .'" value="' . esc_attr( $email ) . '" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue" />';
        if (isset($options_profile['sex_status']) && $options_profile['sex_status'] == 2) {
            $form .= '<p><select name="nx" class="newsletter-sex">';
            $form .= '<option value="m">' . $options_profile['sex_male'] . '</option>';
            $form .= '<option value="f">' . $options_profile['sex_female'] . '</option>';
            $form .= '</select></p>';
        }     
        // Extra profile fields
        for ($i = 1; $i <= NEWSLETTER_PROFILE_MAX; $i++) {
            if ($options_profile['profile_' . $i . '_status'] != 2)
                continue;
            if ($options_profile['profile_' . $i . '_type'] == 'text') {
                $form .= '<p><input class="newsletter-profile newsletter-profile-' . $i . '" type="text" name="np' . $i . '" value="' . $options_profile['profile_' . $i] . '" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/></p>';
            }
            if ($options_profile['profile_' . $i . '_type'] == 'select') {
                $form .= '<p>' . $options_profile['profile_' . $i] . '<br /><select class="newsletter-profile newsletter-profile-' . $i . '" name="np' . $i . '">';
                $opts = explode(',', $options_profile['profile_' . $i . '_options']);
                for ($t = 0; $t < count($opts); $t++) {
                    $form .= '<option>' . trim($opts[$t]) . '</option>';
                }
                $form .= '</select></p>';
            }
        }
        if (strpos($options_profile['subscribe'], 'http://') !== false) {
            $form .= '<button class="btn-send flat-button">'.esc_html__( 'SEND', 'bookflare' ).'</button>';
        } else {
            $form .= '<button class="btn-send flat-button">'.esc_html__( 'SEND', 'bookflare' ).'</button>';
        }
        $form .= '</form>';
        return $form;
    }
    function widget($args, $instance) {
        global $newsletter;
        extract($args);
        echo sprintf($before_widget);
        if (!empty($instance['title'])) { 
                    $title = apply_filters('widget_title', $instance['title'], $instance); 
                }
        $buffer=$desc='';
        $texteditor =  $instance['texteditor'];
        $texteditor2 =  $instance['texteditor2'];
        $exist_img = !empty( $instance['image_url'] );
        $exist_desc = !empty( $instance['desc'] );
        $url = esc_url($instance['image_url']);
        ?>
        <div class="widget-subscribe flat-text-center" style="background: url(<?php echo esc_url($url); ?>) center center no-repeat;background-size: cover;">
            <h4 class="widget-title"><?php echo esc_attr($title) ; ?> </h4>
            <p class="text-sub"><?php echo esc_html($instance['desc']) ;?></p>
            <?php echo wp_kses_post($texteditor) ;?>
            <div class="wrap-description">
                <p class="description"> <?php echo wp_kses_post($texteditor2) ;?></p>
            </div>
            <div class="wrap-form-subscribe">
                <?php 
                    $buffer .= apply_filters('widget_text', $instance['text'], $instance);
                    $options = get_option('newsletter');
                    $options_profile = get_option('newsletter_profile');
                    $buffer .= $desc;
                    if (stripos($instance['text'], '<form') === false) {
                        $form = '';
                        $form .= '<div class="newsletter newsletter-widget">';
                        $form .= Themesflat_NewsletterWidget::get_widget_form( $instance );
                        $form .= '</div>';
                        // Canot user directly the replace, since the form is different on the widget...
                        if (strpos($buffer, '{subscription_form}') !== false)
                            $buffer = str_replace('{subscription_form}', $form, $buffer);
                        else {
                            if (strpos($buffer, '{subscription_form_') !== false) {
                                // TODO: Optimize with a method to replace only the custom forms
                                $buffer = $newsletter->replace($buffer);
                            } else {
                                echo  sprintf($form);
                            }
                        }
                    } else {
                        $buffer = str_ireplace('<form', '<form method="post" action="' . esc_attr($newsletter->get_subscribe_url())  . '" onsubmit="return newsletter_check(this)"', $buffer);
                    }

                ?>
            </div>   
        </div>
        <?php
        
        // That replace all the remaining tags
        $buffer = $newsletter->replace($buffer);
        echo sprintf($buffer);
        echo sprintf($after_widget);

    }
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['placeholder'] = strip_tags($new_instance['placeholder']);
        $instance['desc'] = $new_instance['desc'];
        $instance['image_url'] = esc_url($new_instance['image_url']);
        $instance['text'] = $new_instance['text'];
        $instance['texteditor'] = $new_instance['texteditor'];
        $instance['texteditor2'] = $new_instance['texteditor2'];
        return $instance;
    }
    function form($instance) {
        if (!is_array($instance)) $instance = array();
        $instance = array_merge(array('title'=>'','texteditor'=>'','texteditor2'=>'' ,'text'=>'','placeholder'=>'','image_url'=>'','desc'=>''), $instance);
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <?php esc_html_e('Title','bookflare');?>:
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
            </label>
            <label for="<?php echo esc_attr($this->get_field_id('desc')); ?>">
                <?php esc_html_e('Description 1','bookflare');?>:
                <textarea class="widefat" rows="4" cols="20" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo wp_kses_post($instance['desc']); ?></textarea>
            </label>
            <label for="<?php echo esc_attr($this->get_field_id('texteditor')); ?>">
                <?php esc_html_e('Free Tutorial','bookflare');?>:
                <textarea class="widefat" rows="4" cols="20" id="<?php echo esc_attr($this->get_field_id('texteditor')); ?>" name="<?php echo esc_attr($this->get_field_name('texteditor')); ?>"><?php echo wp_kses_post($instance['texteditor']); ?></textarea>
            </label>
            <label for="<?php echo esc_attr($this->get_field_id('texteditor2')); ?>">
                <?php esc_html_e('Description 2','bookflare');?>:
                <textarea class="widefat" rows="4" cols="20" id="<?php echo esc_attr($this->get_field_id('texteditor2')); ?>" name="<?php echo esc_attr($this->get_field_name('texteditor2')); ?>"><?php echo wp_kses_post($instance['texteditor2']); ?></textarea>
            </label>
            <label for="<?php echo esc_url($this->get_field_id('image_url')); ?>">
                <p class="img-class">
            <label class="img-label" for="<?php echo esc_attr($this->get_field_id('image_url')); ?>"><?php esc_html_e('Image for background','bookflare'); ?></label><br />
            <input type="text" class="img" name="<?php echo esc_attr($this->get_field_name('image_url')); ?>" id="<?php echo esc_attr($this->get_field_id('image_url')); ?>" value="<?php echo esc_attr($instance['image_url']); ?>" />
            <input type="button" class="select-img" value="Select Image" />
        </p>
            </label>
            <label for="<?php echo esc_attr($this->get_field_id('placeholder')); ?>">
                <?php esc_html_e('Placeholder','bookflare');?>:
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('placeholder')); ?>" name="<?php echo esc_attr($this->get_field_name('placeholder')); ?>" type="text" value="<?php echo esc_attr($instance['placeholder']); ?>" />
            </label>
            <label for="<?php echo esc_attr($this->get_field_id('text')); ?>">
                <?php esc_html_e('Introduction','bookflare');?>:
                <textarea class="widefat" rows="10" cols="20" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>"><?php echo esc_html($instance['text']); ?></textarea>
            </label>
        <p><?php echo esc_html("Use the tag {subscription_form} to place the subscription form within your personal text.","bookflare");?></p>
        <script>
            var image_field;
            jQuery(function ($) {
                $(document).on('click', 'input.select-img', function (evt) {
                    image_field = $(this).siblings('.img');
                    tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true',null);
                    return false;
                });
                window.send_to_editor = function (html) {
                    imgurl = $(html).attr('src');
                    image_field.val(imgurl);
                    tb_remove();
                }
            });
        </script>
        <?php
    }
}
add_action( 'widgets_init', 'themesflat_register_newletter' );
/**
 * Register widget
 *
 * @return void
 * @since 1.0
 */
function hrw_enqueue() {
    wp_enqueue_media();
}

add_action('admin_enqueue_scripts', 'hrw_enqueue');


function themesflat_register_newletter() {
    register_widget( 'Themesflat_NewsletterWidget');
}
?>