<?php
/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'themesflat_title_section_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function themesflat_title_section_shortcode_params() {
	vc_map( array(
		'base'        => 'title-section',
		'name'        =>esc_html__( 'Themesflat: Title Section', 'bookflare' ),
		'icon' 		  => THEMESFLAT_ICON,
		'category'    =>esc_html__( 'Themesflat', 'bookflare' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     =>esc_html__( 'Title', 'bookflare' ),
				'param_name'  => 'title',
				'description' => __('Insert "|" To Change Color After "|"  ', 'bookflare')
			),
			array(
                'type' => 'textfield',
                'class' => '',
                'heading' => __('Font Size', 'bookflare'),
                'param_name' => 'font_size',
                'value' => '',
                'description' => __('Font Size.', 'bookflare')
            ),
			array(
                'type' => 'textfield',
                'class' => '',
                'heading' => __('Line Height', 'bookflare'),
                'param_name' => 'line_height',
                'value' => '',
                'description' => __('Line Height.', 'bookflare')
            ),
			array (
                'type' => 'colorpicker',
                'heading' => __( 'Color', 'bookflare' ),
                'param_name' => 'color',
                'value' => '',
                'description' => __( 'Color', 'bookflare' ),
            ),
            array (
                'type' => 'colorpicker',
                'heading' => __( 'Color Sub Title', 'bookflare' ),
                'param_name' => 'color_sub',
                'value' => '',
                'description' => __( 'Color', 'bookflare' ),
            ),
            array (
                'type' => 'colorpicker',
                'heading' => __( 'Color Before', 'bookflare' ),
                'param_name' => 'color_before',
                'value' => '',
                'description' => __( 'Color Before "|"', 'bookflare' ),
            ),
            array (
                'type' => 'colorpicker',
                'heading' => __( 'Color After', 'bookflare' ),
                'param_name' => 'color_after',
                'value' => '',
                'description' => __( 'Color After "|"', 'bookflare' ),
            ),
			array(
				'type'       => 'textarea',
				'heading'    =>esc_html__( 'Content', 'bookflare' ),
				'param_name' => 'content'
			),
			array(
				'type'       => 'dropdown',
				'heading'    =>esc_html__( 'Position', 'bookflare' ),
				'param_name' => 'position',
				'value' => array(
					__( 'Text Left', 'bookflare' ) => 'left',
					__( 'Text Center', 'bookflare' ) => 'center',
					__( 'Text Right', 'bookflare' ) => 'right'
				)
			),
			   
			array(
				'type'       => 'textfield',
				'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class_en'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		)
	) );
}
add_shortcode( 'title-section', 'themesflat_title_section_shortcode_render' );
function themesflat_title_section_shortcode_render($atts, $content = null){
	extract(shortcode_atts(array(
        'class_en' => '',
		'title'  => '',
		'font_size' => '',
		'line_height' => '24',
		'position'  => '',
        'color' => '#192836',
		'styles'	  => 'default',
		'css'   => '',
		'color_after'=>'#ec5252',
		'color_before'=>'#192836',
		'color_sub'=>'#515e6f'
    ), $atts));
	
	$class = $style = array();
	$class[] = 'tflat-title';
	$class[] = $class_en;
	$class[] = $styles;
	$class[] = $position;
	$style[] = " font-size: {$font_size}px; line-height:{$line_height}px";
	$style[] = "color: $color";

	$find_title = strpos($title,'|');

	if ($find_title !== false) {
		// tontai
		$title_cut = explode('|',$title);
		$success_title = sprintf('
			<span style="color:%4$s">%1$s</span><span class="color-title-style" style="color:%3$s">%2$s</span>',$title_cut[0],$title_cut[1],esc_attr($color_after),esc_attr($color_before)); 
	} else {
		$success_title = sprintf('<span style="color:%2$s">%1$s</span>',$title,esc_attr($color));
	}
	ob_start();
	?>
	<div class="<?php echo esc_attr(implode(' ', $class));?>">
		<div class="flat-title flat-text-<?php esc_attr_e($position); ?>">
			<?php if($title):?>
            	<h2 class="title" <?php echo 'style="'. esc_attr(implode('; ', $style))  .'"';?>>
            		<?php echo $success_title;?></h2>
            <?php endif;
            if($content):?>
            	<p class="description" <?php echo 'style="color:'. esc_attr($color_sub)  .'"';?>><?php echo wp_kses_post($content);?></p>
            <?php endif;?>
        </div>
	</div>
	<?php
	return ob_get_clean();
}