<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * visual composer
	 */
    class WPBakeryShortCode_Iconboxlist extends WPBakeryShortCodesContainer {
    }
}
add_filter( 'themesflat/shortcode/iconbox_class', 'themesflat_custom_shortcodes_class', 10, 2 );
add_filter( 'themesflat/shortcode/Iconboxlist_slider_class', 'themesflat_custom_shortcodes_class', 10, 2 );
add_action( 'vc_before_init', 'themesflat_iconboxlist_shortcode_params' );

function themesflat_iconboxlist_shortcode_params() {
	vc_map( array(
		'name'                    =>esc_html__( 'Themesflat: Icon Box List', 'bookflare' ),
		'base'                    => 'iconboxlist',
		'as_parent'               => array( 'only' => 'iconbox' ), 
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'params'                  => array(	
			array(
				'type' => 'textfield',
				'heading' =>esc_html__( 'Number Transform', 'bookflare' ),
				'param_name' => 'transform',
				'description' =>esc_html__( 'Add number you want change translateY Ex:50% or -50%', 'bookflare' )
			),

			array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Background Color or Background Image', 'bookflare' ),
					'param_name' => 'img_and_cl',
					'value'       => array(		
						esc_html__( 'Background Color', 'bookflare' ) => 'style_cl',					
						esc_html__( 'Background Image', 'bookflare' ) => 'style_bg',
						),
					'std '		 => 'style_cl'
				),
			// Image Icon
			array(
	            'type' => 'attach_image',
	            'class' => '',
	            'heading' => __('Image Icon', 'bookflare'),
	            'param_name' => 'image',
	            'value' => '',
	            'dependency' => array(
						'element' => 'img_and_cl',
						'value'	=> array('style_bg'),
						),
	            'description' => __('Select image icon in this element', 'bookflare')
	        ),
			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Backgound Icon', 'bookflare' ),
				'param_name' => 'icon_color_background',
				'dependency' => array(
						'element' => 'img_and_cl',
						'value'	=> array('style_cl'),
						),
				'std' => '#ffffff'
				),
			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Backgound Icon Active', 'bookflare' ),
				'param_name' => 'icon_color_background_active',
				'dependency' => array(
						'element' => 'img_and_cl',
						'value'	=> array('style_cl'),
						),
				'std' => '#f3728b'
				),		
			array(
				'type' => 'textfield',
				'heading' =>esc_html__( 'Extra class name', 'bookflare' ),
				'param_name' => 'class',
				'description' =>esc_html__( 'Add class for your design', 'bookflare' )
			),
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		),
		'js_view' => 'VcColumnView'
	) );
}

add_shortcode( 'iconboxlist', 'themesflat_shortcode_iconboxlist_slider' );

/**
 * This function will be use to handle 
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function themesflat_shortcode_iconboxlist_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'iconboxlist', $atts );
	$config = $atts;
	$icon_color_background  = sprintf('%1$s',$atts['icon_color_background']);
	$icon_color_background_active  = sprintf('%1$s',$atts['icon_color_background_active']);
	if($config['transform'] != ''){$transform = $config['transform'];}else{$transform = '0%';}
	if($config['transform'] == ''){$changeposition = 'relative';}else{$changeposition = 'absolute';}
	unset( $config['class'] );
	unset( $config['css'] );
	$class = apply_filters( 'themesflat/shortcode/Iconboxlist_slider_class', array( 'iconboxlist', $atts['class']), $atts );
	if ($atts['img_and_cl']==='style_cl') {
		return sprintf( '<section class="flat-featured style3">
	        <div class="wrap-featured" style="transform: translateY(%2$s);position: %3$s;" data-icon_color_background="%4$s" data-icon_color_background_active="%5$s"  >
	            <div class="container">
	            	%1$s
	            </div>
	        </div>
	    </section>
		',do_shortcode( $content ),
		$transform,
		$changeposition,
		$icon_color_background,
		  	$icon_color_background_active);
	} else {
	$img_count = wp_get_attachment_image_url( $atts['image'], 'full', false,array('class'=>'responsive'));
		return sprintf('<div class="flat-counter style2">
					    <div class="wrap-counter" style="transform: translateY(%2$s);position: %3$s;" data-url_img_count="%4$s">
					        <div class="container">
					            <div class="counters clear-sub-columns style2">
					            	%1$s
					            </div>
					        </div>
					    </div>
					</div>',
					do_shortcode( $content ),
					$transform,
					$changeposition,
					$img_count
				);
	}
	
}
