<?php 

add_action( 'vc_before_init', 'themesflat_flat_feature_shortcode_params' );
// Element Class 
function themesflat_flat_feature_shortcode_params() {
	$icons_params = themesflat_map_icons('icon','IconBox');
	$params = array_merge( $icons_params, array(
		// Title
		array(
			'type'             => 'textfield',
			'heading'          =>esc_html__( 'Title iconbox ', 'bookflare' ),
			'param_name'       => 'title'
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Position item', 'bookflare' ),
			'param_name' => 'position_item',
			'value' => array(
				esc_html__( 'Left', 'bookflare' )   => 'left',
				esc_html__( 'Center', 'bookflare' )   => 'center',
				esc_html__( 'Right', 'bookflare' )   => 'right'
				),
			'std '		 => 'left'
		),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Icon', 'bookflare' ),
			'param_name' => 'icon_color',
			'std' => '#ffffff'
			),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Text', 'bookflare' ),
			'param_name' => 'text_color',
			'std' => '#ffffff'
			),


		// Extra Class
		array(
			'type'       => 'textfield',
			'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
			'param_name' => 'class'
		),
	));	
    vc_map( 
        array(
            'name'                    =>esc_html__( 'Themesflat: Feature', 'bookflare' ),
			'base'                    => 'flat_feature',
			'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
			'icon' 					  => THEMESFLAT_ICON,
			'params'                  => $params,
			'admin_label' => true,
		)
    );                        
}    
add_shortcode( 'flat_feature', 'themesflat_shortcode_flat_feature' );
 function themesflat_shortcode_flat_feature( $atts,$content = null ) {
    vc_map_get_attributes( 'flat_feature', $atts );
    extract(
        shortcode_atts(
            array(
            	'title' => '',
            	'position_item' => 'left',
            	'text_color'	=> '#ffffff',
            	'icon_color'	=> '#ffffff',
            ), 
            $atts
        )
    );
 	$atts = vc_map_get_attributes( 'iconbox', $atts );
	$icon_name = themesflat_shortcode_icon_name('icon_',$atts['icon_type']);
   	$icon_value = !empty( $icon_name ) ? $atts[$icon_name] : '';
   	$flat_icon = sprintf( '<i class="%s"></i>', $icon_value );
   	$flat_positon = esc_attr($position_item);
   	$flat_color_text = esc_attr($text_color);
   	$flat_color_icon = esc_attr($icon_color);
   	ob_start();
    return sprintf('<div class="iconbox have_icon %3$s style1">
            <div class="iconbox-icon" data-icon_color="%5$s">%1$s</div>
            <div class="iconbox-content">
                <h5 class="title" style="color:%4$s;">%2$s</h5>
            </div>
        </div>',$flat_icon,esc_html($title),$flat_positon,$flat_color_text,$flat_color_icon);
     return ob_get_clean(); 
} 