<?php 

add_action( 'vc_before_init', 'themesflat_courses_shortcode_params' );
// Element Class 
function themesflat_courses_shortcode_params() {
    vc_map( 
        array(
            'name'                    =>esc_html__( 'Themesflat: Courses', 'bookflare' ),
			'base'                    => 'courses',
			'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
			'icon' 					  => THEMESFLAT_ICON,
			'params'                  => array(	
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Grid or list colums', 'bookflare' ),
					'param_name' => 'style',
					'value'       => array(		
						esc_html__( 'Grid Columns', 'bookflare' ) => 'style1',					
						esc_html__( 'List', 'bookflare' ) => 'style2',
						esc_html__( 'Grid Simple', 'bookflare' ) => 'style3',
						esc_html__( 'Grid Carousel', 'bookflare' ) => 'style4',	
						),
					'std '		 => 'style1'
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Grid Columns', 'bookflare' ),
					'param_name'  => 'grid_columns',
					'description' => esc_html__( 'The number of columns for grid and grid masonry layout', 'bookflare' ),
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style1','style3','style4'),
						),
					'value'       => array(		
						esc_html__( '1 Columns', 'bookflare' ) => 1,
						esc_html__( '2 Columns', 'bookflare' ) => 2,					
						esc_html__( '3 Columns', 'bookflare' ) => 3,	
						esc_html__( '4 Columns', 'bookflare' ) => 4
						)
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Grid Columns Size Images ', 'bookflare' ),
					'param_name'  => 'images_style',
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style1'),
						),
					'value'       => array(		
						esc_html__( 'Image Style 1 (436x269)', 'bookflare' ) => 1,
						esc_html__( 'Image Style 2 (350x250)', 'bookflare' ) => 2,
						)
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Grid Columns Size Images ', 'bookflare' ),
					'param_name'  => 'images_style_simple',
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style3'),
						),
					'value'       => array(		
						esc_html__( 'Image Style 1 (730x286)', 'bookflare' ) => 1,
						esc_html__( 'Image Style 2 (350x287)', 'bookflare' ) => 2,
						)
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Grid Columns Size Images ', 'bookflare' ),
					'param_name'  => 'images_style_simple_carousel',
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style4'),
						),
					'value'       => array(		
						esc_html__( 'Image Style 1 (350x250)', 'bookflare' ) => 1,
						esc_html__( 'Image Style 2 (350x213)', 'bookflare' ) => 2,
						esc_html__( 'Image Style 2 (350x236)', 'bookflare' ) => 3,
						)
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number post',  "bookflare" ),
				  'param_name' => 'number_post',
				  'value' => __( '12', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Show  Post by Post ID Number (Ex:150,213,...)',  'bookflare' ),
				  'param_name' => 'number_post_show_id',
				  'value' => __( '', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'List ID Post Exclude (Ex: 102,321,...)',  "bookflare" ),
				  'param_name' => 'number_post_exclude',
				  'value' => __( '', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'List ID Category Exclude (Ex: 102,321,...)',  "bookflare" ),
				  'param_name' => 'number_cat_exclude',
				  'value' => __( '', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number text description except',  "bookflare" ),
				  'param_name' => 'number_post_except',
				  'value' => __( '20', 'bookflare' ),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order by', 'bookflare' ),
					'param_name' => 'order_by',
					'value' => array(
						esc_html__( 'None', 'bookflare' )   => 'none',
						esc_html__( 'ID', 'bookflare' )   => 'ID',
						esc_html__( 'Author', 'bookflare' )   => 'author',
						esc_html__( 'Title', 'bookflare' )   => 'title',
						esc_html__( 'Name', 'bookflare' )   => 'name',
						esc_html__( 'Date', 'bookflare' )   => 'date'
						),
					'std '		 => 'date'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order List post', 'bookflare' ),
					'param_name' => 'order_direction',
					'dependency' => array(
						'element' => 'order_by',
						'value'	=> array('ID','author','title','name','date'),
						),
					'value' => array(
						esc_html__( 'DESC', 'bookflare' )   => 'DESC',
						esc_html__( 'ASC', 'bookflare' )   => 'ASC'
						),
					'std '		 => 'DESC'
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Enable Pagination', 'bookflare' ),
					'param_name' => 'blog_pagination',
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style1','style2','style3'),
						),
					'value'      => array(
						esc_html__( 'Yes, please', 'bookflare' ) => 'yes'
						),
					'std '		 => 'no'
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Enable Tabs Courses', 'bookflare' ),
					'param_name' => 'tab_courses',
					'value'      => array(
						esc_html__( 'Yes, please', 'bookflare' ) => 'yes'
						),
					'std '		 => 'no'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Position Pagination', 'bookflare' ),
					'param_name' => 'pagination_ps',
					'dependency' => array(
						'element' => 'blog_pagination',
						'value'	=> array('yes'),
						),
					'value'      => array(
						esc_html__( 'Left', 'bookflare' )   => 'left',
						esc_html__( 'Center', 'bookflare' )   => 'center',
						esc_html__( 'Right', 'bookflare' )   => 'right'
						),
					'std '		 => 'center'
				)
           )
        )
    );                        
}    
add_shortcode( 'courses', 'themesflat_shortcode_courses' );
 function themesflat_shortcode_courses( $atts,$content = null ) {
    vc_map_get_attributes( 'courses', $atts );
    extract(
        shortcode_atts(
            array(
            	'style' 					=> 'style1',
            	'number_post'				=> '12',
            	'order_direction'			=> '',
            	'number_post_except' 		=> '20',
            	'blog_pagination'			=> 'no',
            	'grid_columns'				=> 3,
            	'order_by'					=> 'none',
            	'pagination_ps'				=> 'center',
            	'tab_courses'				=> 'no',
            	'images_style'				=> 1,
            	'number_post_exclude'		=> '',
            	'images_style_simple'		=> 1,
            	'images_style_simple_carousel' =>1,
            	'number_post_show_id'		=>'',
            	'number_cat_exclude'		=>''
            ), 
            $atts
        )
    );
    $courses_columns = $grid_columns;
	    	switch ($courses_columns) {
	    case 1:
			$courses_columns_class = 'col-lg-12 col-md-12';
			break;
		case 2:
			$courses_columns_class = 'col-lg-6 col-md-6';
			break;
		case 3:
			$courses_columns_class = 'col-lg-4 col-md-4';
			break;
		default:
			$courses_columns_class = 'col-lg-3 col-md-6';
			break;
		}
    
    if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}

		$args = array(
			'post_type'              => array( 'lp_course' ),
			'post_status'            => array( 'publish' ),
			'nopaging'               => false,
			'posts_per_page'         => $number_post,
			'paged' 				 => $paged, 
			'post__not_in' 			 => explode(",", $number_post_exclude),
			
		);
		$args_cat_excluder = array();
		if($number_cat_exclude !==''){
			$args_cat_excluder =array(
					'tax_query' => array(
			                array(
			                    'taxonomy' => 'course_category',
			                    'field'    => 'term_id',
			                    'terms'    => explode(",", $number_cat_exclude),
			                    'operator' => 'NOT IN'
			                ),
		           		 ),
				);
		}
		$args_mer = array();
		if($number_post_show_id !== ''){
			$args_mer = array('post__in' =>	explode(',', $number_post_show_id),
								'orderby'                => 'none',
								'order'                  => '',
						);
		}else{
			$args_mer = array(
				'order'                  => $order_direction,
				'orderby'                => $order_by,
			);
		}
		$args_s = array_merge($args,$args_cat_excluder,$args_mer);

	$courses_archive_excerpt = themesflat_choose_opt('courses_archive_excerpt')?themesflat_choose_opt('courses_archive_excerpt'):'';
	$review_is_enable = themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' );
	$courses_length = (int)themesflat_choose_opt('courses_archive_post_excepts_length')?(int)themesflat_choose_opt('courses_archive_post_excepts_length'):40;
    ob_start();
$query = new WP_Query( $args_s );
$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages;
switch ($style) {
	case 'style1':?>
	<?php if($tab_courses=='yes'){?>
		<ul class="flat-filter-isotype style1 text-center ">
	    	<?php themesflat_category_Lp($number_cat_exclude);  ?>
	    </ul>
	<?php } ?>
	<div class="flat-courses clear-sub-columns clearfix isotope-courses style2">
		<?php
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();
				
				$course_id = get_the_ID();
				$course_item = LP_Course::get_course( $course_id );
				if($review_is_enable){
					$course_rate   = learn_press_get_course_rate( $course_id );
			    	$total         = learn_press_get_course_rate_total( $course_id );
				}
		?>
			<div class="<?php echo esc_attr($courses_columns_class); ?> tflat-course-item style2 <?php themesflat_custom_course_price_color();  themesflat_category_slug(get_the_ID()); ?>">
				<article>
				    <div class="course-border border-ra4 transition-vline business-studies">   
				        <div class="course-img img-vline">
				        	<?php if($images_style == 1){
				        		the_post_thumbnail('themesflat-courser-grid-short', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        	}else {
				        		the_post_thumbnail('themesflat-courser-shortcode', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        		}?>
				            <div class="overlay">
				                <span class="vline"></span>
				                <span class="vline vline-bottom"></span>
				            </div>
				            <?php themesflat_custom_course_sale(); ?>
				        </div>
				        <div class="course-content border-f-e6f3ff">
				            <div class="text-wrap border-bt-e6f3ff">
				                <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title();?></a></h6>
				                <p class="teacher"><?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
				                	if(!empty($tflat_teacher)){
										themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
									}?>
								</p>
								<?php if($courses_archive_excerpt == 1): ?>
					                <p class="description"><?php echo themesflat_custom_excerpt($course_id,intval($number_post_except));?></p>
					            <?php endif; ?>
				            </div>
				            <div class="wrap-rating-price">
				                <?php if($review_is_enable): ?>
				                    <div class="wrap-rating">
				                        <?php themesflat_print_rating( $course_rate ); ?>
				                        <div class="number-rating"> <?php echo ( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0; ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' ); ?> </div>
				                    </div>
				                <?php endif; ?>
				                <span class="price v2"><?php  echo themesflat_custom_course_price();?></span>
				            </div>
				        </div>
				    </div>
				</article>
			</div>
			<?php }
			} else {
			} 
			wp_reset_postdata();
		?>
	</div>
	<?php break;
	case 'style3':
	 if($tab_courses=='yes'){?>
		<ul class="flat-filter-isotype style1 text-center ">
	    	<?php themesflat_category_Lp();  ?>
	    </ul>
	<?php } ?>
	<div class="flat-courses clear-sub-columns clearfix isotope-courses style2">
		<?php
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();
				$course_id = get_the_ID();
				$course_item = LP_Course::get_course( $course_id );
				if($review_is_enable){
					$course_rate   = learn_press_get_course_rate( $course_id );
			    	$total         = learn_press_get_course_rate_total( $course_id );
				}
			    $title = get_the_title( );
		?>	
			<div class="<?php echo esc_attr($courses_columns_class); ?> tflat-course-item style5 <?php themesflat_custom_course_price_color();  themesflat_category_slug(get_the_ID()); ?>">
				<article>
					<div class="course-border transition-vline">   
		                <div class="course-img img-vline">
		                	<?php if($images_style_simple == 1){
				        		the_post_thumbnail('themesflat-courser-grid-simple', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        	}else {
				        		the_post_thumbnail('themesflat-courser-grid-simple2', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        		}?>
		                    <div class="overlay">
		                        <span class="vline"></span>
		                        <span class="vline vline-bottom"></span>
		                    </div>
		                    <?php themesflat_custom_course_sale(); ?>
		                </div>
		                <div class="course-content">
		                    <div class="text-wrap ">
		                        <?php if($review_is_enable): ?>
				                    <div class="wrap-rating">
				                        <?php themesflat_print_rating( $course_rate ); ?>
				                        <div class="number-rating"> <?php echo ( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0; ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' ); ?> </div>
				                    </div>
				                <?php endif; ?>
		                        <p class="teacher"><?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
		                        if(!empty($tflat_teacher)){
									themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
								}?></p>
		                        <h6 class="title"><a href="<?php the_permalink($course_id); ?>"><?php echo $title;?></a></h6>
		                        <?php if($courses_archive_excerpt == 1): ?>
					                <p class="description"><?php echo themesflat_custom_excerpt($course_id,intval($number_post_except));?></p>
					            <?php endif; ?>
		                        <div class="wrap-btn">
		                            <a href="<?php the_permalink($course_id); ?>" class="btn-learn-more"><?php esc_html_e('LEARN MORE','bookflare') ?></a>
		                        </div>
		                    </div>
		                </div>
		        	</div> <!-- /.course -->
		        </article>
			</div>
			<?php }
			} else {
			} 
			wp_reset_postdata();
		?>
	</div>
	<?php break;
	case 'style4':?>
	<div class="flat-popular-courses style4">
		<div class="flat-carousel" data-column="<?php echo $grid_columns; ?>" data-column2="2" data-loop="false"  data-column3="1" data-gap ="0" data-dots="false" data-nav="true">
	        <div class="flat-courses clearfix owl-carousel">
	        	<?php
					if ( $query->have_posts() ) {
						while ( $query->have_posts() ) {
						$query->the_post();
							$course_id = get_the_ID();
							$course_item = LP_Course::get_course( $course_id );
							if($review_is_enable){
								$course_rate   = learn_press_get_course_rate( $course_id );
						    	$total         = learn_press_get_course_rate_total( $course_id );
							}
						    $title = get_the_title( );
					?>
					<div class="course-grid tflat-course-item style2 <?php themesflat_custom_course_price_color();  themesflat_category_slug(get_the_ID()); ?>">
				<article>
				    <div class="course-border border-ra4 transition-vline business-studies">   
				        <div class="course-img img-vline">
				        	<?php if($images_style_simple_carousel == 1){
				        		the_post_thumbnail('themesflat-courser-shortcode', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        	}else if($images_style_simple_carousel == 2) {
				        		the_post_thumbnail('themesflat-courser-grid-carosel', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        		}else {
				        			the_post_thumbnail('themesflat-courser-grid-carosel', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));
				        		}?>
				            <div class="overlay">
				                <span class="vline"></span>
				                <span class="vline vline-bottom"></span>
				            </div>
				            <?php themesflat_custom_course_sale(); ?>
				        </div>
				        <div class="course-content border-f-e6f3ff">
				            <div class="text-wrap border-bt-e6f3ff">
				                <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title();?></a></h6>
				                <p class="teacher"><?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
				                if(!empty($tflat_teacher)){
									themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
								}?>
								</p>
								<?php if($courses_archive_excerpt == 1): ?>
					                <p class="description"><?php echo themesflat_custom_excerpt($course_id,intval($number_post_except));?></p>
					            <?php endif; ?>
				            </div>
				            <div class="wrap-rating-price">
				                <?php if($review_is_enable): ?>
				                    <div class="wrap-rating">
				                        <?php themesflat_print_rating( $course_rate ); ?>
				                        <div class="number-rating"> <?php echo ( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0; ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' ); ?> </div>
				                    </div>
				                <?php endif; ?>
				                <span class="price v2"><?php  echo themesflat_custom_course_price();?></span>
				            </div>
				        </div>
				    </div>
				</article>
			</div>
					<?php }
						} else {
						} 
						wp_reset_postdata();
					?>
	            
	        </div>
	    </div>
	</div>
	<?php break;
	default: ?>
		<div class="flat-courses style3 courses-grid-v3-page courses-list">
			<div class="heading clearfix border-f-e6f3ff border-ra4">
                <div class="taskbar">
                    <ul class="list">
                    	<?php count_courses_video(); ?>
                    </ul>
                </div>
                <div class="select-order flat-text-right">
                    <div class="wrap-select">
                        <select class="order-by">
                            <option><?php esc_html_e('Sort By: release date','bookflare'); ?></option>
                        </select>
                    </div>
                </div>
            </div> <!--  /.heading -->
			<?php
			if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();
				$course_id = get_the_ID();
				$course_item = LP_Course::get_course( $course_id );
				if($review_is_enable){
					$course_rate   = learn_press_get_course_rate( $course_id );
			    	$total         = learn_press_get_course_rate_total( $course_id );
				}
			?>	
	        <div class="tflat-course-item style4 <?php themesflat_custom_course_price_color(); ?> ">
	            <div class=" course-border border-f-e6f3ff clear-sub-columns cl-content transition-vline">
	                <div class="course-img-box">
	                    <div class="course-img img-vline">
	                        <?php the_post_thumbnail('themesflat-courser-grid-carosel', array('class'=>'img-responsive','alt' => esc_html ( get_the_title() )));
				            ?>
	                        <div class="overlay">
	                            <span class="vline"></span>
	                            <span class="vline vline-bottom"></span>
	                        </div>
	                        <?php themesflat_custom_course_sale(); ?>
	                    </div>
	                </div>
	                <div class="course-content">
	                    <div class="text-wrap ">
	                        <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title();?></a></h6>
	                        <p class="teacher"><?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
	                        	if(!empty($tflat_teacher)){
									themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
								}?>
								</p>
	                        <?php if($courses_archive_excerpt == 1): ?>
					                <p class="description"><?php _e(themesflat_custom_excerpt($course_id,intval($number_post_except)));?></p>
					            <?php endif; ?>
	                    </div>
	                    <div class="wrap-rating-price border-t-e6f3ff">
			                <?php if($review_is_enable): ?>
			                    <div class="wrap-rating on-line">
			                        <?php themesflat_print_rating( $course_rate ); ?>
			                        <div class="number-rating"> <?php echo ( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0; ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' ); ?> </div>
			                    </div>
			                <?php endif; ?>
			                <div class="date-list on-line"><?php echo get_the_date('d.M.y');?></div>
			                <div class="list-view on-line"><?php esc_html_e('Views: ','bookflare'); ?><span class="color-2ebd59" ><?php echo getPostViews($course_id);?></span></div>
			                <span class="price v2"><?php echo themesflat_custom_course_price();?></span>

			            </div>
	                </div>
	            </div>
	        </div>
	        <?php }
			} else {
			} ?>
	    </div>
<?php break;
}
wp_reset_postdata();
if ( $blog_pagination == 'yes' ): ?>
        <div class="flat-paginations_courses <?php esc_attr_e($pagination_ps); ?> ">
			<?php
				get_template_part( 'tpl/pagination' );		
			?>
		</div>     
	<?php endif;
return ob_get_clean(); 
} 